% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_existing_strat.R
\name{sample_existing_strat}
\alias{sample_existing_strat}
\title{Sample Existing Data Based on Strata}
\usage{
sample_existing_strat(
  existing,
  toSample,
  nSamp,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{toSample}{A data frame specifying the desired sample sizes for each strata.}

\item{nSamp}{Numeric. Number of desired samples. \code{existing}, \code{include} and \code{force} influence this value.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}
}
\value{
An \code{sf} object that is a sub-sample of \code{existing}
}
\description{
This function takes a data frame of existing data, a data frame of desired sample sizes
for each strata, the number of samples to take, and optionally a file name and overwrite
parameter. It returns a sample of the existing data based on the desired sample sizes for
each strata, and optionally writes the resulting samples to a file.
}
\keyword{internal}
