% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{cluster.plot}
\alias{cluster.plot}
\title{Plot data clusters}
\usage{
cluster.plot( ddata, classes, main="", col.stock=NULL,
              plotCI = FALSE, conf.level = 0.68, ...)
}
\arguments{
\item{ddata}{Matrix of points}

\item{classes}{A factor including the cluster values}

\item{main}{Title for the plot}

\item{col.stock}{Colors for the plotted classes}

\item{plotCI}{Plot means with confidence intervals}

\item{conf.level}{The confidence interval for the standard error of the mean}

\item{...}{Additional parameters to be passed to 'plot' or 'ldahist' if one dimension}
}
\value{
None
}
\description{
Plots data clusters
}
\examples{
data(shape)
library(vegan)
cap.res = capscale(getStdWavelet(shape) ~ getMasterlist(shape)$pop)

eig=eigenvals(cap.res,constrained=TRUE)
eig.ratio = eig/sum(eig)

cluster.plot(scores(cap.res)$sites[,1:2],getMasterlist(shape)$pop
,plotCI=TRUE
,xlab=paste("CAP1 (",round(eig.ratio[1]*100,1),"\%)",sep="")
,ylab=paste("CAP2 (",round(eig.ratio[2]*100,1),"\%)",sep="")
,main="Canonical clustering"
)

}
\references{
Oksanen, J., Blanchet, F.G., Kindt, R., Legendre, P., Minchin, P.R., O'Hara, R.B., Simpson, G.L., Solymos, P., Stevens, M.H.H. and Wagner, H. (2013). \code{\link{vegan}}: Community Ecology Package. R package version 2.0-10.
}
\author{
Lisa Anne Libungan
}
