% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{observation_impute_cpp}
\alias{observation_impute_cpp}
\title{Get imputed data}
\usage{
observation_impute_cpp(index_xtrain, index_s, xtrain, xtest, S)
}
\arguments{
\item{index_xtrain}{Positive integer. Represents a sequence of row indices from \code{xtrain},
i.e. \code{min(index_xtrain) >= 1} and \code{max(index_xtrain) <= nrow(xtrain)}.}

\item{index_s}{Positive integer. Represents a sequence of row indices from \code{S},
i.e. \code{min(index_s) >= 1} and \code{max(index_s) <= nrow(S)}.}

\item{xtrain}{Numeric matrix.}

\item{xtest}{Numeric matrix. Represents a single test observation.}

\item{S}{Integer matrix of dimension \code{n_combinations x m}, where \code{n_combinations} equals
the total number of sampled/non-sampled feature combinations and \code{m} equals
the total number of unique features. Note that \code{m = ncol(xtrain)}. See details
for more information.}
}
\value{
Numeric matrix
}
\description{
Get imputed data
}
\details{
\code{S(i, j) = 1} if and only if feature \code{j} is present in feature
combination \code{i}, otherwise \code{S(i, j) = 0}. I.e. if \code{m = 3}, there
are \code{2^3 = 8} unique ways to combine the features. In this case \code{dim(S) = c(8, 3)}.
Let's call the features \code{x1, x2, x3} and take a closer look at the combination
represented by \code{s = c(x1, x2)}. If this combination is represented by the second row,
the following is true: \code{S[2, 1:3] = c(1, 1, 0)}.

The returned object, \code{X}, is a numeric matrix where
\code{dim(X) = c(length(index_xtrain), ncol(xtrain))}. If feature \code{j} is present in
the k-th observation, that is \code{S[index_[k], j] == 1}, \code{X[k, j] = xtest[1, j]}.
Otherwise \code{X[k, j] = xtrain[index_xtrain[k], j]}.
}
\author{
Nikolai Sellereite
}
\keyword{internal}
