% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{mcar_mask_generator}
\alias{mcar_mask_generator}
\title{Missing Completely at Random (MCAR) Mask Generator}
\usage{
mcar_mask_generator(masking_ratio = 0.5, paired_sampling = FALSE)
}
\arguments{
\item{masking_ratio}{Numeric between 0 and 1. The probability for an entry in the generated mask to be 1 (masked).}

\item{paired_sampling}{Boolean. If we are doing paired sampling. So include both S and \eqn{\bar{S}}.
If \code{TRUE}, then \code{batch} must be sampled using \code{\link[=paired_sampler]{paired_sampler()}} which ensures that the \code{batch} contains
two instances for each original observation. That is, \code{batch} \eqn{= [X_1, X_1, X_2, X_2, X_3, X_3, ...]}, where
each entry \eqn{X_j} is a row of dimension \eqn{p} (i.e., the number of features).}
}
\description{
A mask generator which masks the entries in the input completely at random.
}
\details{
The mask generator mask each element in the \code{batch} (N x p) using a component-wise independent Bernoulli
distribution with probability \code{masking_ratio}. Default values for \code{masking_ratio} is 0.5, so all
masks are equally likely to be generated, including the empty and full masks.
The function returns a mask of the same shape as the input \code{batch}, and the \code{batch} can contain
missing values, indicated by the "NaN" token, which will always be masked.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, p)} where N is the number of observations in the \code{batch} and \eqn{p} is the number of features.
\item Output: \eqn{(N, p)}, same shape as the input
}
}

\examples{
\dontrun{
mask_gen <- mcar_mask_generator(masking_ratio = 0.5, paired_sampling = FALSE)
batch <- torch::torch_randn(c(5, 3))
mask_gen(batch)
}

}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
