% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_waterfall.R
\name{sv_waterfall}
\alias{sv_waterfall}
\alias{sv_waterfall.default}
\alias{sv_waterfall.shapviz}
\title{SHAP Waterfall Plot}
\usage{
sv_waterfall(object, ...)

\method{sv_waterfall}{default}(object, ...)

\method{sv_waterfall}{shapviz}(
  object,
  row_id = 1L,
  max_display = 10L,
  order_fun = function(s) order(abs(s)),
  sort_fun = NULL,
  fill_colors = c("#f7d13d", "#a52c60"),
  format_shap = getOption("shapviz.format_shap"),
  format_feat = getOption("shapviz.format_feat"),
  format_fun = NULL,
  contrast = TRUE,
  show_connection = TRUE,
  show_annotation = TRUE,
  annotation_size = 3.2,
  ...
)
}
\arguments{
\item{object}{An object of class "shapviz".}

\item{...}{Arguments passed to \code{ggfittext::geom_fit_text()}.
For example, \code{size = 9} will use fixed text size in the bars and \code{size = 0}
will altogether suppress adding text to the bars.}

\item{row_id}{A single row number to plot.}

\item{max_display}{Maximum number of features (with largest absolute SHAP values)
should be plotted? If there are more features, they will be collapsed to one feature.
The default is ten in order to not overload the plot. Set to \code{Inf} to show
all features.}

\item{order_fun}{Function specifying the order of the variables/SHAP values.
It maps the vector \code{s} of SHAP values to sort indices from 1 to \code{length(s)}.
The default is \code{function(s) order(abs(s))}.
To plot without sorting, use \code{function(s) 1:length(s)} or
\code{function(s) length(s):1}.}

\item{sort_fun}{Deprecated in favour of \code{order_fun}.}

\item{fill_colors}{A vector of exactly two fill colors: the first for positive
SHAP values, the other for negative ones.}

\item{format_shap}{Function used to format SHAP values. The default uses the
global option \code{shapviz.format_shap}, which equals to
\code{function(z) prettyNum(z, digits = 3, scientific = FALSE)} by default.}

\item{format_feat}{Function used to format numeric feature values. The default uses
the global option \code{shapviz.format_feat}, which equals to
\code{function(z) prettyNum(z, digits = 3, scientific = FALSE)} by default.}

\item{format_fun}{Deprecated. Use \code{format_shap} and/or \code{format_feat} instead.}

\item{contrast}{Logical flag that detemines whether to use white text in dark arrows.
Default is \code{TRUE}.}

\item{show_connection}{Should connecting lines be shown? Default is \code{TRUE}.}

\item{show_annotation}{Should "f(x)" and "E(f(x))" be plotted? Default is \code{TRUE}.}

\item{annotation_size}{Size of the annotation text (f(x)=... and E(f(x))=...).}
}
\value{
An object of class "ggplot" representing a waterfall plot.
}
\description{
Creates a waterfall plot of SHAP values of one single observation. The value of
f(x) denotes the prediction on the SHAP scale, while E(f(x)) refers to the baseline
SHAP value. The plot has to be read from bottom to top.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method.

\item \code{shapviz}: SHAP waterfall plot for an object of class "shapviz".
}}

\examples{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1]), label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)
x <- shapviz(fit, X_pred = dtrain, X = iris[, -1])
sv_waterfall(x)
sv_waterfall(x, row_id = 123, max_display = 2, size = 9, fill_colors = 4:5)

X <- as.data.frame(matrix(1:100, nrow = 10))
S <- as.matrix(X)
shp <- shapviz(S, X)
sv_waterfall(shp)
}
\seealso{
\code{\link{sv_force}}
}
