% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{c.shapviz}
\alias{c.shapviz}
\title{Concatenates "shapviz" Objects}
\usage{
\method{c}{shapviz}(...)
}
\arguments{
\item{...}{Any number of (optionally named) "shapviz" objects.}
}
\value{
A "mshapviz" object.
}
\description{
This function combines two or more (usually named) "shapviz" objects
to an object of class "mshapviz".
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
s1 <- shapviz(S, X, baseline = 4)[1L]
s2 <- shapviz(S, X, baseline = 4)[2L]
s <- c(shp1 = s1, shp2 = s2)
s
}
\seealso{
\code{\link{mshapviz}}
}
