% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{[.shapviz}
\alias{[.shapviz}
\title{Subsets "shapviz" Object}
\usage{
\method{[}{shapviz}(x, i, j, ...)
}
\arguments{
\item{x}{An object of class "shapviz".}

\item{i}{Row subsetting.}

\item{j}{Column subsetting.}

\item{...}{Currently unused.}
}
\value{
A new object of class "shapviz".
}
\description{
Use standard square bracket subsetting to select rows and/or columns of
SHAP values, feature values, and SHAP interaction values of a "shapviz" object.
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
x <- shapviz(S, X, baseline = 4)
x[1L, "x"]
x[1L]
x[c(FALSE, TRUE), ]
x[, "x"]
}
\seealso{
\code{\link[=shapviz]{shapviz()}}
}
