% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalised_models.R
\name{LavaanModel}
\alias{LavaanModel}
\title{Writing lavaan model}
\usage{
LavaanModel(adjacency, residual_covariance = NULL, manifest = NULL)
}
\arguments{
\item{adjacency}{binary adjacency matrix of the Directed Acyclic Graph
(transpose of the asymmetric matrix A in Reticular Action Model notation).
The row and column names of this matrix must be defined.}

\item{residual_covariance}{binary and symmetric matrix encoding the nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation). By default, this is the identity matrix (no
residual covariance).}

\item{manifest}{optional vector of manifest variable names.}
}
\value{
A character string that can be used in argument \code{model} in
  \code{\link[lavaan]{sem}}.
}
\description{
Returns model specification in \code{\link[lavaan]{lavaan}} syntax from (i)
the adjacency matrix of a Directed Acyclic Graph (asymmetric matrix A in
Reticular Action Model notation), and (ii) a binary matrix encoding nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation).
}
\examples{
# Definition of the model structure
layers <- list(
  c("var1", "var2", "var3"),
  c("var4", "var5"),
  c("var6", "var7", "var8")
)
dag <- LayeredDAG(layers)

# Writing lavaan syntax
model_spec <- LavaanModel(adjacency = dag)

# Checking the matrices generated by lavaan
mylavaan <- lavaan::sem(model = model_spec)
regsem::extractMatrices(mylavaan)$A
regsem::extractMatrices(mylavaan)$S

# Including residual correlation
res_cov <- diag(ncol(dag))
res_cov[1, 2] <- res_cov[2, 1] <- 1
model_spec <- LavaanModel(
  adjacency = dag,
  residual_covariance = res_cov
)

# Checking the matrices generated by lavaan
mylavaan <- lavaan::sem(model = model_spec)
regsem::extractMatrices(mylavaan)$A
regsem::extractMatrices(mylavaan)$S

# Incorporating latent variables
dag <- LayeredDAG(layers = c(2, 1), n_manifest = 2)
LavaanModel(dag, manifest = paste0("x", 1:6))

}
\references{
\insertRef{lavaanBook}{sharp}
}
\seealso{
\code{\link{PenalisedSEM}}, \code{\link{LavaanMatrix}}
}
