% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalised_models.R
\name{OpenMxMatrix}
\alias{OpenMxMatrix}
\title{Matrix from OpenMx outputs}
\usage{
OpenMxMatrix(vect, adjacency, residual_covariance = NULL)
}
\arguments{
\item{vect}{vector of coefficients to assign to entries of the matrix.}

\item{adjacency}{binary adjacency matrix of the Directed Acyclic Graph
(transpose of the asymmetric matrix A in Reticular Action Model notation).
The row and column names of this matrix must be defined.}

\item{residual_covariance}{binary and symmetric matrix encoding the nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation). By default, this is the identity matrix (no
residual covariance).}
}
\value{
An asymmetric matrix.
}
\description{
Returns a matrix from output of \code{\link[OpenMx]{mxPenaltySearch}}.
}
\seealso{
\code{\link{PenalisedOpenMx}}, \code{\link{OpenMxModel}}
}
