% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_grid.R
\name{LambdaSequence}
\alias{LambdaSequence}
\title{Sequence of penalty parameters}
\usage{
LambdaSequence(lmax, lmin, cardinal = 100)
}
\arguments{
\item{lmax}{maximum value in the grid.}

\item{lmin}{minimum value in the grid.}

\item{cardinal}{number of values in the grid.}
}
\value{
A vector with values between "lmin" and "lmax" and as many values as
  indicated by "cardinal".
}
\description{
Generates a sequence of penalty parameters from extreme values and the
required number of elements. The sequence is defined on the log-scale.
}
\examples{
# Grid from extreme values
mygrid <- LambdaSequence(lmax = 0.7, lmin = 0.001, cardinal = 10)
}
\seealso{
Other lambda grid functions: 
\code{\link{LambdaGridGraphical}()},
\code{\link{LambdaGridRegression}()}
}
\concept{lambda grid functions}
