% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDEC_StationInfo.R
\name{CDEC_StationInfo}
\alias{CDEC_StationInfo}
\title{CDEC Sensor Details (by Station)}
\usage{
CDEC_StationInfo(s)
}
\arguments{
\item{s}{character, a single CDEC station ID (e.g. 'HHM')}
}
\value{
A \code{list} object containing site metadata, sensor metadata, and possibly comments about the site.
}
\description{
Query CDEC Website for Sensor Details
}
\details{
This function requires the \code{rvest} package.
}
\examples{

\donttest{
if(requireNamespace("curl") &
   curl::has_internet() 
) {

  # CDEC API needs a long timeout
  options(timeout = 60000)
  
  CDEC_StationInfo('HHM')  
  
}


}

}
\seealso{
\verb{[CDECquery]}
}
\author{
D.E. Beaudette
}
