#' Search the # of samples to ensure learning given an epsilon.
#'
#' @description Search the # of samples to ensure learning given an epsilon.
#'
#' @param rpart.tree rpart.tree. A Decision tree generated by rpart package.
#' @param n_samples int. The # of samples to be used as initial value to search the minimum necessary to ensure learning.
#' @param delta float. The initial value of delta (need to be greater than epsilon)
#' @param epsilon float. The epsilon to be used in the delta calculation.
#'
#' @usage search_delta_n_samples(rpart.tree, n_samples, delta, epsilon)
#'
#' @return the delta and n_samples values.
#'
#' @export search_delta_n_samples
search_delta_n_samples <- function(rpart.tree, n_samples, delta, epsilon){
    while(delta > epsilon){
        delta = compute_delta(rpart.tree, n_samples, epsilon)
        if(delta <= epsilon){
            lower = n_samples/2
        } else {
            n_samples = n_samples*2
        }
    }
    # searching the best # of samples to ensure learning with a ((1-epsilon)*100)% confidence interval.
    n_samples = search_n_samples(rpart.tree, lower, n_samples, epsilon)
    # computing delta for the # of samples
    delta = compute_delta(rpart.tree, n_samples, epsilon)
    ret = list()
    ret$delta = delta
    ret$n_samples = n_samples

    return (ret)
}
