% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shazam.R
\docType{package}
\name{shazam}
\alias{shazam}
\alias{shazam-package}
\title{The shazam package}
\description{
Provides tools for advanced anaylisis of immunoglobulin (Ig) somatic hypermutation 
(SHM), including BASELINe, a novel method for quantifying antigen-driven selection in 
high-throughput Ig sequencing data.
}
\details{
Dramatic improvements in high-throughput sequencing technologies now enable 
large-scale characterization of Ig repertoires, defined as the collection of transmembrane 
antigen-receptor proteins located on the surface of T and B lymphocytes.

The \code{shazam} package provides tools for advanced analysis of Ig sequences following 
germline segment assignment. Namely, the analysis of SHM. 
Which includes:
 \itemize{
     \item   Statistical analysis of SHM patterns \cr
             Computational models and analyses of SHM have separated the process 
             into two independent components: 
             \enumerate{
                 \item  A mutability model that defines where mutations occur.
                 \item  A nucleotide substitution model that defines the resulting mutation.
             }
             Collectively these are what form the targeting model of SHM. \code{shazam} 
             provides tools to build these mutability and substitution (i.e. targeting) 
             models.
                 
     \item   BASELINe \cr
             Bayesian Estimation of Antigen-driven Selection in Ig Sequences is a 
             novel method for quantifying antigen-driven selection in high-throughput
             Ig sequence data. The targeting model created using \code{shazam} is used 
             to estimate the null distribution of expected mutation frequencies in 
             BASELINe.
             
     \item   Distance calculations \cr
             Based on the underlying SHM targeting (calculated using \code{shazam}) one 
             can compute evolutionary distances between sequences or groups of 
             sequences. This information is particularly useful in understanding and 
             defining clonal relationships.
 }

Below are the functions in \code{shazam} broken down by the three main tasks described
above:
}
\section{Targeting models}{

\itemize{
  \item  \link{createTargetingModel}:     Build a 5-mer targeting model.
  \item  \link{plotMutability}:           Plot 5-mer mutability rates.
}
}

\section{Mutational profiling}{

\itemize{
  \item  \link{collapseByClone}:    Build clonal consensus sequence.
  \item  \link{calcDBObservedMutations}:  Compute observed mutation counts.
  \item  \link{calcDBExpectedMutations}:  Compute expected mutation frequencies.
}
}

\section{Selection analysis}{

\itemize{
  \item  \link{calcBaseline}:             Calculate the BASELINe probability
                                          density functions (PDFs).
  \item  \link{groupBaseline}:            Combine PDFs from sequences grouped
                                          by biological or experimental relevance.
  \item  \link{summarizeBaseline}:        Compute summary statistics from BASELINe PDFs.
  \item  \link{plotBaselineDensity}:      Plot the probability density functions
                                          resulting from selection analysis.
  \item  \link{plotBaselineSummary}:      Plot summary stastistics resulting from 
                                          selection analysis.
}
}

\section{Distance profiling}{

\itemize{
  \item  \link{distToNearest}:            Tune clonal assignment thresholds by calculating 
                                          distances to nearest-neighbors.
  \item  \link{calcTargetingDistance}:    Construct a nucleotide distance matrix from a 
                                          5-mer targeting model.
}
}
\references{
\enumerate{
  \item  Hershberg U, et al. Improved methods for detecting selection by mutation 
           analysis of Ig V region sequences. 
           Int Immunol. 2008 20(5):683-94.
  \item  Uduman M, et al. Detecting selection in immunoglobulin sequences. 
           Nucleic Acids Res. 2011 39(Web Server issue):W499-504.
  \item  Yaari G, et al. Quantifying selection in high-throughput immunoglobulin 
           sequencing data sets. 
           Nucleic Acids Res. 2012 40(17):e134.
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based 
           on synonymous mutations from high-throughput immunoglobulin sequencing data. 
           Front Immunol. 2013 4:358.
 }
}

