% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Separator}
\alias{Separator}
\title{Separator}
\usage{
Separator(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A separator visually separates content into groups.

You can render content in the separator by specifying the component's children.
The component's children can be plain text or a component like Icon.
The content is center-aligned by default.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Separator}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ alignContent }} {\code{'start' | 'center' | 'end'} \cr Where the content should be aligned in the separator.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<ISeparatorStyleProps, ISeparatorStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme (provided through customization.)}
\item {\bold{ vertical }} {\code{boolean} \cr Whether the element is a vertical separator.}
}
}
\examples{
library(shiny.fluent)

if (interactive()) {
  shinyApp(
    ui = Separator("Text"),
    server = function(input, output) {}
  )
}
}
