% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{create_gsheet_db}
\alias{create_gsheet_db}
\title{Function to create new empty 'googlesheet' database}
\usage{
create_gsheet_db(name = NULL, credentials = NULL, credentials_pass_hashed)
}
\arguments{
\item{name}{specify name for 'googlesheet' file. Defaults to random name.}

\item{credentials}{you can pass credentials data to create already populated tables. Provide data.frame object containing variables: timestamp, user_id, user_mail and user_pass. If there are multiple records with the same user_id, the most recent will be kept only.}

\item{credentials_pass_hashed}{mandatory when putting some credentials data. Are the passwords already hashed with 'scrypt' package? Takes TRUE (if hashed) or FALSE (if not hashed and need hashing)}
}
\value{
id of the 'googlesheet' file. After creation you need to provide it to \code{login_server()}.
}
\description{
Function to create new empty 'googlesheet' database
}
\examples{
if(googlesheets4::gs4_has_token()){

gsheet.id <- create_gsheet_db()

database <- gsheet_get_db(gsheet.id)

# you can then pass 'gsheet.id' to you 'login_server' call
#
# login_server(db_method = "gsheet",
#              gsheet_file = gsheet.id,
#              ...)
#

print(database)

googledrive::drive_trash(gsheet.id)

}
}
