% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{tabset}
\alias{tabset}
\title{Create Semantic UI tabs}
\usage{
tabset(
  tabs,
  active = NULL,
  id = generate_random_id("menu"),
  menu_class = "top attached tabular",
  tab_content_class = "bottom attached segment"
)
}
\arguments{
\item{tabs}{A list of tabs. Each tab is a list of three elements - first
element defines menu item, second element defines tab content, third optional element defines tab id.}

\item{active}{Id of the active tab. If NULL first tab will be active.}

\item{id}{Id of the menu element (default: randomly generated id)}

\item{menu_class}{Class for the menu element (default: "top attached
tabular")}

\item{tab_content_class}{Class for the tab content (default: "bottom attached
segment")}
}
\description{
This creates tabs with content using Semantic UI styles.
}
\details{
You may access active tab id with \code{input$<id>_tab}.
}
\examples{
tabset(list(
list(menu = shiny::div("First link"),
     content = shiny::div("First content")),
list(menu = shiny::div("Second link"),
     content = shiny::div("Second content"))
))
}
