% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-file.R
\name{fileInput}
\alias{fileInput}
\title{File Upload Control}
\usage{
fileInput(inputId, label, multiple = FALSE, accept = NULL, width = NULL,
  buttonLabel = "Browse...", placeholder = "No file selected")
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{multiple}{Whether the user should be allowed to select and upload
multiple files at once. \bold{Does not work on older browsers, including
Internet Explorer 9 and earlier.}}

\item{accept}{A character vector of MIME types; gives the browser a hint of
what kind of files the server is expecting.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}

\item{buttonLabel}{The label used on the button. Can be text or an HTML tag
object.}

\item{placeholder}{The text to show before a file has been uploaded.}
}
\description{
Create a file upload control that can be used to upload one or more files.
}
\details{
Whenever a file upload completes, the corresponding input variable is set
to a dataframe. This dataframe contains one row for each selected file, and
the following columns:
\describe{
  \item{\code{name}}{The filename provided by the web browser. This is
  \strong{not} the path to read to get at the actual data that was uploaded
  (see
  \code{datapath} column).}
  \item{\code{size}}{The size of the uploaded data, in
  bytes.}
  \item{\code{type}}{The MIME type reported by the browser (for example,
  \code{text/plain}), or empty string if the browser didn't know.}
  \item{\code{datapath}}{The path to a temp file that contains the data that was
  uploaded. This file may be deleted if the user performs another upload
  operation.}
}
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      fileInput("file1", "Choose CSV File",
        accept = c(
          "text/csv",
          "text/comma-separated-values,text/plain",
          ".csv")
        ),
      tags$hr(),
      checkboxInput("header", "Header", TRUE)
    ),
    mainPanel(
      tableOutput("contents")
    )
  )
)

server <- function(input, output) {
  output$contents <- renderTable({
    # input$file1 will be NULL initially. After the user selects
    # and uploads a file, it will be a data frame with 'name',
    # 'size', 'type', and 'datapath' columns. The 'datapath'
    # column will contain the local filenames where the data can
    # be found.
    inFile <- input$file1

    if (is.null(inFile))
      return(NULL)

    read.csv(inFile$datapath, header = input$header)
  })
}

shinyApp(ui, server)
}
}
\seealso{
Other input elements: \code{\link{actionButton}},
  \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}}, \code{\link{dateInput}},
  \code{\link{dateRangeInput}}, \code{\link{numericInput}},
  \code{\link{passwordInput}}, \code{\link{radioButtons}},
  \code{\link{selectInput}}, \code{\link{sliderInput}},
  \code{\link{submitButton}}, \code{\link{textAreaInput}},
  \code{\link{textInput}}
}
\concept{input elements}
