% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{trigger-action}
\alias{trigger-action}
\alias{.trigger_action}
\alias{.trigger_action_js}
\title{Trigger filtering panel action}
\usage{
.trigger_action(session, action, params = NULL)

.trigger_action_js(action, params = list(), ns = function(id) id)
}
\arguments{
\item{session}{Shiny session object.}

\item{action}{Id of the action.}

\item{params}{List of parameters passed to specific action method.}

\item{ns}{Namespace function (if used within Shiny modal).}
}
\value{
No return value (`.trigger_action` - sends message to the browser) or
  character string storing JS code for sending input value to Shiny server (`.trigger_action_js`).
}
\description{
The two functions that allow to trigger a specific filtering panel action directly
from Shiny server (.trigger_action) or application browser (.trigger_action_js)
attached to a specific JS event, e.g. onclick.

Check Details section to see possible options.
}
\details{
The list of possible actions:

\itemize{
\item{update_filter}{ Calls `shinyCohortBuilder:::gui_update_filter` that triggers filter arguments update.}
\item{add_step}{ Calls `shinyCohortBuilder:::gui_add_step` that triggers adding a new filtering step (based on configuration of the previous one).}
\item{rm_step}{ Calls `shinyCohortBuilder:::gui_rm_step` used to remove a selected filtering step.},
\item{clear_step}{ Calls `shinyCohortBuilder:::gui_clear_step` used to clear filters configuration in selected step.}
\item{update_step}{ Calls `shinyCohortBuilder:::gui_update_step` used to update filters and feedback plots for the specific filter GUI panel.}
\item{update_data_stats}{ Calls `shinyCohortBuilder:::gui_update_data_stats` that is called to update data statistics. }
\item{show_repro_code}{ Calls `shinyCohortBuilder:::gui_show_repro_code` that is used to show reproducible code. }
\item{run_step}{ Calls `shinyCohortBuilder:::gui_run_step` used to trigger specific step data calculation. }
\item{show_state}{ Calls `shinyCohortBuilder:::gui_show_state` that is used to show filtering panel state json. }
\item{input_state}{ Calls `shinyCohortBuilder:::gui_input_state` that is used to generate modal in which filtering panel state can be provided (as json). }
\item{restore_state}{ Calls `shinyCohortBuilder:::gui_restore_state` used for restoring filtering panel state based on provided json. }
\item{show_attrition}{ Calls `shinyCohortBuilder:::gui_show_attrition` a method used to show attrition data plot(s).}
}

Both `.trigger_action` and `.trigger_action_js` methods are exported for advanced use only.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyCohortBuilder)

  shiny::addResourcePath(
    "shinyCohortBuilder",
    system.file("www", package = "shinyCohortBuilder")
  )
  ui <- fluidPage(
    tags$head(
      shiny::tags$script(type = "text/javascript", src = file.path("shinyCohortBuilder", "scb.js"))
    ),
    tags$button(
      "Trigger action from UI", class = "btn btn-default",
      onclick = .trigger_action_js("uiaction", params = list(a = 1))
    ),
    actionButton("send", "Trigger action from server")
  )

  server <- function(input, output, session) {
    observeEvent(input$send, {
      .trigger_action(session, "serveraction", params = list(a = 2))
    })
    observeEvent(input$action, {
      print(input$action)
    })
  }

  shinyApp(ui, server)
}
}
