% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{run_app}
\alias{run_app}
\title{Run the Shiny Application}
\usage{
run_app(
  config_file,
  data_folder = "",
  custom_modules = NULL,
  nthreads = 1L,
  ...
)
}
\arguments{
\item{config_file}{The name of the yaml configuration file}

\item{data_folder}{Optional directory prefix for data files. Use this
argument if you want to version your files across different folders}

\item{custom_modules}{Optional list of available custom modules. See the
'Details' section.}

\item{nthreads}{Optional number of threads/cores to speed up loading files
and computing correlations on UNIX-based systems. Default is 1}

\item{...}{Further optional arguments.}
}
\value{
Runs the app
}
\description{
This function should be run only after you have created the configuration
file and placed all required files in the app folder. See
\code{vignette("quickstart", package = "shinyExprPortal")} for help with setup or
\code{vignette("fullguide", package = "shinyExprPortal")} for a complete
configuration guide.
}
\details{
\code{custom_modules} should contain a list of names for user-defined
modules that are loaded in the environment before calling run_app. Each
module should be accompanied by the corresponding mod_moduleName_ui,
mod_moduleName_server moduleName_config functions. These functions could be
placed in a custom_modules.R file, for example, and loaded using \code{source}.
The package will then parse the configuration file, and if it contains one of
the custom module names, it will call the module configuration parsing
function and add it to the interface. See \code{vignette("customization")} for a
complete example.

Please note that if running on Windows, nthreads will be always set to 1
due to limitations on the current implementation.
}
\examples{
if (interactive()) {
run_app("config.yaml", nthreads = 4)
}
}
\seealso{
\code{\link[=create_config_wizard]{create_config_wizard()}} to create a configuration using a wizard,
\code{\link[=create_config_template]{create_config_template()}} to create a configuration file template.
}
