% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickCheckbox.R
\name{pickCheckboxInput}
\alias{pickCheckboxInput}
\alias{updatePickCheckboxInput}
\title{Select set of active checkbox groups and their values}
\usage{
pickCheckboxInput(
  inputId,
  label,
  choices,
  choicesNames = pickCheckboxNames(choices),
  choicesLabels = pickCheckboxLabels(choices),
  selected = NULL,
  max_groups = length(choices),
  ...
)

updatePickCheckboxInput(
  session,
  inputId,
  choices,
  choicesNames,
  choicesLabels,
  selected
)
}
\arguments{
\item{inputId}{Id of `pickCheckboxInput` component.}

\item{label}{The component label.}

\item{choices}{Named list of values. Each element defines a separate checkbox group.
The element name defines checkbox group id, whereas its value set of values that
should be available in the related checkbox group.}

\item{choicesNames}{Named list of values (with the same names as `choices`).
Each element value defines what labels should be displayed for each checkbox group.
See \link{pickCheckboxNamesAndLabels}.}

\item{choicesLabels}{Named vector storing labels for each checkbox group.
The parameter is also used to display values in component dropdown.
See \link{pickCheckboxNamesAndLabels}.}

\item{selected}{The initial value or value to be updated. Subset of `choices`.}

\item{max_groups}{Number of maximum number of checkboxes allowed in the component.
Used to limit amount of new checkbox groups added with `updatePickCheckboxInput`.}

\item{...}{Extra parameters passed to \link[shinyWidgets]{pickerInput}.}

\item{session}{Shiny session object.}
}
\value{
Nested list of `shiny.tag` objects, defining html stricture of the input,
or no value in case of usage of `updatePickCheckboxInput` method.
}
\description{
The component is connection of dropdown (\link[shinyWidgets]{pickerInput}) and
set of checkbox groups (\link[shiny]{checkboxGroupInput}).

When specific value is selected in dropdown, the related checkbox group becomes active
and becomes visible to the user.
}
\examples{
# Possible choices and selected configurations

# Choices as list of unnamed options
# Names are the same as values in the component (if not precised elsewhere)
choices_unnamed <- list(
  fruits = c("orange", "apple", "lemon"),
  vegetables = c("potato", "carrot", "broccoli")
)
# selected only fruits plus orange one within
selected_unnamed <- list(
  fruits = c("orange")
)
# Names for each group precised separately
choices_names = list(
  fruits = c("Orange", "Apple", "Lemon"),
  vegetables = c("Potato", "Carrot", "Broccoli")
)

# Choices as list of named options
# Names are treated as checkbox options labels
choices_named <- list(
  fruits = c("Orange" = "orange", "Apple" = "apple", "Lemon" = "lemon"),
  vegetables = c("Potato" = "potato", "Carrot" = "carrot", "Broccoli" = "broccoli")
)
# selected: fruits plus orange and vegetables carrot
selected_named <- list(
  fruits = c("orange"),
  vegetables= c("carrot")
)

# Same but vegetables selected but empty
# Set group as NA to no options checked (same effect in server input)
selected_named_empty <- list(
  fruits = c("orange"),
  vegetables = NA
)

# Specifying picker and group labels ("key" = "name" rule)
choices_labels <- list("fruits" = "Fruits", "vegetables" = "Vegetables")

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    sidebarLayout(sidebarPanel(
      pickCheckboxInput(
        "pci1", "1. No names at all",
        choices = choices_unnamed, selected = selected_unnamed
      ), hr(),
      pickCheckboxInput(
        "pci2", "2. Names provided as `choicesNames`",
        choices = choices_unnamed, selected = selected_unnamed, choicesNames = choices_names
      ), hr(),
      pickCheckboxInput(
        "pci3", "3. Names provided directly in choices",
        choices = choices_named, selected = selected_named
      ), hr(),
      pickCheckboxInput(
        "pci4", "4. Group as NA value to select group (without any choices)",
        choices = choices_named, selected = selected_named_empty
      ), hr(),
      pickCheckboxInput(
        "pci5", "5. Group names provided as `choicesLabels`",
        choices = choices_named, selected = selected_named_empty, choicesLabels = choices_labels
      )
    ),
    mainPanel(
      verbatimTextOutput("out1"),
      verbatimTextOutput("out2"),
      verbatimTextOutput("out3"),
      verbatimTextOutput("out4"),
      verbatimTextOutput("out5")
    ))
  )
  server <- function(input, output, session) {
    output$out1 <- renderPrint({print("Result 1."); input$pci1})
    output$out2 <- renderPrint({print("Result 2."); input$pci2})
    output$out3 <- renderPrint({print("Result 3."); input$pci3})
    output$out4 <- renderPrint({print("Result 4."); input$pci4})
    output$out5 <- renderPrint({print("Result 5."); input$pci5})
  }
  shinyApp(ui, server)
}

}
