% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_exchange_rates.R
\name{GetExchangeRates}
\alias{GetExchangeRates}
\alias{get_exchange_rates_symbol,}
\alias{try_exchange_rates_direct_and_indirect}
\alias{get_exchange_rates_symbol}
\title{Functions get_exchange_rates_symbol, try_exchange_rates_direct_and_indirect
and GetExchangeRates}
\usage{
GetExchangeRates(from_curr, to_curr, from_date, to_date = from_date)

get_exchange_rates_symbol(from_curr, to_curr, from_date, to_date = from_date)

try_exchange_rates_direct_and_indirect(date, from_curr, to_curr, tries = 8)
}
\arguments{
\item{from_curr}{character, currency symbol}

\item{to_curr}{character, currency symbol}

\item{from_date}{character, date}

\item{to_date}{character, date}

\item{date}{character, desired date}

\item{tries}{numeric try how many days before desired date}
}
\value{
data.frame

data.frame

numeric vector
}
\description{
get_exchange_rates_symbol: uses getSymbol

GetExchangeRates: uses getFX and getSymbol
}
\examples{
from_curr <- c("CAD", "JPY", "USD")
to_curr <- c("USD", "USD", "EUR")

\donttest{
# Success
recent_date <- as.character(Sys.Date() - 7)
GetExchangeRates(from_curr = from_curr, to_curr = to_curr, recent_date, recent_date)

# last date mismatch day
GetExchangeRates(from_curr = from_curr, to_curr = to_curr, "2023-10-27", "2023-10-30")

# weekend, warning, gets only FX, fails for getSymbol

GetExchangeRates(from_curr = from_curr, to_curr = to_curr, "2023-10-28", "2023-10-28")
GetExchangeRates(from_curr = from_curr, to_curr = to_curr, "2023-10-29", "2023-10-29")
GetExchangeRates(from_curr = from_curr, to_curr = to_curr, "2023-07-08", "2023-07-09")

# fails for FX, > 180 days
GetExchangeRates(from_curr = from_curr, to_curr = to_curr, "2023-04-03", "2023-04-05")

# failure for getSymbol, when none is USD
GetExchangeRates(from_curr = "BRL", to_curr = "COP", "2023-07-07")

# getSymbol success
get_exchange_rates_symbol(from_curr = from_curr, to_curr = to_curr, "2023-07-03", "2023-07-05")

# getSymbol > 180 days ok
get_exchange_rates_symbol(from_curr = from_curr, to_curr = to_curr, "2023-04-03", "2023-04-05")

# failure, weekend days
weekend_failure <- try(get_exchange_rates_symbol(
  from_curr = from_curr,
  to_curr = to_curr, "2023-07-08", "2023-07-09"
), silent = TRUE)
weekend_failure

# works
try_exchange_rates_direct_and_indirect("2023-07-08", from_curr, to_curr, tries = 8)
try_exchange_rates_direct_and_indirect("2023-07-08", "BRL", "USD", tries = 8)
try_exchange_rates_direct_and_indirect("2023-07-08", "USD", "BRL", tries = 8)

# works indirectly
recent_date <- as.character(Sys.Date() - 7)
try_exchange_rates_direct_and_indirect(recent_date, "COP", "BRL", tries = 8)

# works with FX only, provided, not greater than 180 days

GetExchangeRates(from_curr = "COP", to_curr = "BRL", recent_date)
}
}
\references{
Ryan JA, Ulrich JM (2023). \emph{quantmod: Quantitative Financial
Modelling Framework}. R package version 0.4.25,
\url{https://CRAN.R-project.org/package=quantmod}.
}
\keyword{exchange}
