% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Appbar.R
\name{f7Appbar}
\alias{f7Appbar}
\alias{f7Back}
\alias{f7Next}
\title{Framework7 appbar}
\usage{
f7Appbar(..., leftPanel = FALSE, rightPanel = FALSE)

f7Back(targetId)

f7Next(targetId)
}
\arguments{
\item{...}{Any UI content such as \link{f7Searchbar}, \link{f7Next} and
\link{f7Back}. It is best practice to wrap \link{f7Next} and
\link{f7Back} in a \link{f7Flex}.}

\item{leftPanel}{Whether to enable the left panel. FALSE by default.}

\item{rightPanel}{Whether to enable the right panel. FALSE by default.}

\item{targetId}{\link{f7Tabs} id.}
}
\description{
\link{f7Appbar} is displayed on top of \link{f7Navbar}. \link{f7Appbar} can also
trigger \link{f7Panel}.

\link{f7Back} is a button to go back in \link{f7Tabs}.

\link{f7Next} is a button to go next in \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 cities <- names(precip)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7Appbar(
       f7Flex(f7Back(targetId = "tabset"), f7Next(targetId = "tabset")),
       f7Searchbar(id = "search1", inline = TRUE)
     ),
     f7TabLayout(
       navbar = f7Navbar(
         title = "f7Appbar",
         hairline = FALSE,
         shadow = TRUE
       ),
       f7Tabs(
         animated = FALSE,
         swipeable = TRUE,
         id = "tabset",
         f7Tab(
           tabName = "Tab 1",
           icon = f7Icon("envelope"),
           active = TRUE,
           "Text 1"
         ),
         f7Tab(
           tabName = "Tab 2",
           icon = f7Icon("today"),
           active = FALSE,
           "Text 2"
         ),
         f7Tab(
           tabName = "Tab 3",
           icon = f7Icon("cloud_upload"),
           active = FALSE,
           "Text 3"
         )
       )
     )
   ),
   server = function(input, output) {}
 )
}
}
