% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Messages.R
\name{f7MessageBar}
\alias{f7MessageBar}
\alias{updateF7MessageBar}
\title{Framework7 message bar.}
\usage{
f7MessageBar(inputId, placeholder = "Message")

updateF7MessageBar(
  inputId,
  value = NULL,
  placeholder = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{\link{f7MessageBar} unique id.}

\item{placeholder}{New placeholder value.}

\item{value}{New value.}

\item{session}{Shiny session object.}
}
\description{
\link{f7MessageBar} creates a message text container to type new messages.
Insert before \link{f7Messages}. See examples.

\link{updateF7MessageBar} updates message bar content on the server side.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "Update message bar",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Message bar",
        hairline = FALSE,
        shadow = TRUE
      ),
      toolbar = f7Toolbar(
        position = "bottom",
        f7Link(label = "Link 1", href = "https://www.google.com"),
        f7Link(label = "Link 2", href = "https://www.google.com", external = TRUE)
      ),
      # main content
      f7Segment(
        container = "segment",
        f7Button("updateMessageBar", "Update value"),
        f7Button("updateMessageBarPlaceholder", "Update placeholder")
      ),
      f7MessageBar(inputId = "mymessagebar", placeholder = "Message"),
      uiOutput("messageContent")
    )
  ),
  server = function(input, output, session) {

    output$messageContent <- renderUI({
      req(input$mymessagebar)
      tagList(
        f7BlockTitle("Message Content", size = "large"),
        f7Block(strong = TRUE, inset = TRUE, input$mymessagebar)
      )
    })

    observeEvent(input$updateMessageBar, {
      updateF7MessageBar(
        inputId = "mymessagebar",
        value = "sjsjsj"
      )
    })

    observeEvent(input$updateMessageBarPlaceholder, {
      updateF7MessageBar(
        inputId = "mymessagebar",
        placeholder = "Enter your message"
      )
    })
  }
 )
}
}
