% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7SmartSelect}
\alias{f7SmartSelect}
\alias{updateF7SmartSelect}
\title{Framework7 smart select}
\usage{
f7SmartSelect(
  inputId,
  label,
  choices,
  selected = NULL,
  openIn = c("page", "sheet", "popup", "popover"),
  searchbar = TRUE,
  multiple = FALSE,
  maxlength = NULL,
  virtualList = FALSE
)

updateF7SmartSelect(
  inputId,
  selected = NULL,
  choices = NULL,
  multiple = NULL,
  maxLength = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{Select input label.}

\item{choices}{The new choices.}

\item{selected}{The new value for the input.}

\item{openIn}{Smart select type: either \code{c("sheet", "popup", "popover")}.
Note that the search bar is only available when the type is popup.}

\item{searchbar}{Whether to enable the search bar. TRUE by default.}

\item{multiple}{Whether to allow multiple values.}

\item{maxlength}{Maximum items to select when multiple is TRUE.}

\item{virtualList}{Enable Virtual List for smart select if your select has a lot
of options. Default to FALSE.}

\item{maxLength}{Maximum items to select when multiple is TRUE.}

\item{...}{Parameters used to update the smart select,
use same arguments as in \code{\link{f7SmartSelect}}.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\link{f7SmartSelect} is smarter than the classic \link{f7Select},
allows for choices filtering, ...

\link{updateF7SmartSelect} changes the value of a smart select input on the client.
}
\examples{
# Smart select input
if (interactive()) {
library(shiny)
library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7SmartSelect"),
       f7SmartSelect(
         inputId = "variable",
         label = "Choose a variable:",
         selected = "drat",
         choices = colnames(mtcars)[-1],
         openIn = "popup"
       ),
       tableOutput("data")
     )
   ),
   server = function(input, output) {
     output$data <- renderTable({
       mtcars[, c("mpg", input$variable), drop = FALSE]
     }, rownames = TRUE)
   }
 )
}
# Update smart select
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7SmartSelect"),
      f7Button("updateSmartSelect", "Update Smart Select"),
      f7SmartSelect(
        inputId = "variable",
        label = "Choose a variable:",
        selected = "drat",
        choices = colnames(mtcars)[-1],
        openIn = "popup"
      ),
      tableOutput("data")
    )
  ),
  server = function(input, output, session) {
    output$data <- renderTable({
      mtcars[, c("mpg", input$variable), drop = FALSE]
    }, rownames = TRUE)

    observeEvent(input$updateSmartSelect, {
      updateF7SmartSelect(
        inputId = "variable",
        openIn = "sheet",
        selected = "hp",
        choices = c("hp", "gear"),
        multiple = TRUE,
        maxLength = 3
      )
    })
  }
 )
}
}
