% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyPredict.R
\name{shinyPredict}
\alias{shinyPredict}
\title{Makes shiny application for predictions}
\usage{
shinyPredict(
  models,
  data,
  path,
  info,
  title = "Predictions",
  shinytheme = "cerulean"
)
}
\arguments{
\item{models}{List of models for prediction. All models must have same y-variable and same class. Classes "lm", "glm", and "coxph" are allowed.
If list is named, names are used as titles.}

\item{data}{data.frame for prediction. Must include union of variables used in models.}

\item{path}{character string of path where shiny application is added}

\item{info}{html-file added in Info-tab, if missing creation date is shown}

\item{title}{Title for application}

\item{shinytheme}{Theme used in application}
}
\value{
character string of path where shiny application is added
}
\description{
Makes shiny application for predictions
}
\note{
All variables must be numeric or factors.

Function creates files 'app.R', 'ModelInfo.html', and 'Models.RData' to path folder
Prediction are made by opening file 'app.R' in Rstudio and running it.
Select model in left sidebar panel. Select also x-variable values for prediction.
For continuous variable you may select range using slider input.
In Plot-tab, select variable for x-axis (in coxph-models only time-variable is possible).
You may choose number of predictions calculate in using slider input below plot.
Predictions with 95\% confidence interval are shown.
In Data-tab data and predicted values are show.
Summary-tab shows the summary of current model.
Info-tab show additional information provided by user.

Actual data is not loaded to path folder.  'model' and 'x' are removed from lm-models.
It is advised to use 'model = FALSE,y=FALSE' for coxph-models,
and 'x = FALSE,y=FALSE, model=FALSE' for lm- and glm-models.

In top of left sidebar panel is text input area with title 'Add plot script'.
You may add styling for plot using ggplot style, e.g. '+ggtitle("Solar")+theme_bw()'
adds title to plot and changes theme. Press 'SUBMIT' after typing text.
}
\examples{
if(interactive()){
library(survival)
data(lung)
lung$sex<-factor(lung$sex)
lung$ph.ecog<-factor(lung$ph.ecog)

tmp.m3<-coxph(Surv( time , status )~sex+age,data=lung,model = FALSE,y=FALSE)
tmp.m4<-coxph(Surv( time , status )~sex+age+ph.ecog,data=lung,model = FALSE,y=FALSE)

shinyPredict(models=list("Model 1"=tmp.m3,tmp.m4),
                 data=lung[,c("time","status","sex","age","ph.ecog")],path = "./",
                 title="Predicting lung cancer mortality")


library(splines)
data("airquality")
airquality$Month.f<-factor(airquality$Month)
airquality$Solar.R.f<-cut(airquality$Solar.R,3)

tmp.m0<-glm(Ozone~Solar.R+Temp,data=airquality,x = FALSE,y=FALSE, model=FALSE)
tmp.m1<-glm(Ozone~Solar.R+Temp+Month.f,data=airquality,x = FALSE,y=FALSE,model=FALSE)
tmp.m2<-update(tmp.m1,~.-Temp+ns(Temp,knots = c(72,79,85)))
tmp.m2A<-update(tmp.m1,~.-Solar.R+Solar.R.f)
tmp.m2B<-update(tmp.m2,~.+Solar.R.f:ns(Temp,knots = c(72,79,85)))

print(shinyPredict(models=list("Simple model"=tmp.m0,
                                   tmp.m1,
                                   "Model with splines"=tmp.m2,
                                   "Model with two factors"=tmp.m2A,
                                   "Model with interaction"=tmp.m2B),
                       data=airquality[,c("Ozone","Solar.R","Temp","Month.f","Solar.R.f")],
                       path = "./",
                       title="Predicting Ozone",shinytheme="paper"))

}
}
\author{
Jari Haukka \email{jari.haukka@helsinki.fi}
}
\concept{predict}
\concept{shiny}
