% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{confirmSweetAlert}
\alias{confirmSweetAlert}
\title{Launch a confirmation dialog}
\usage{
confirmSweetAlert(session, inputId, title = "Are you sure ?", text = NULL,
  type = NULL, danger_mode = FALSE, btn_labels = c("Cancel", "Confirm"))
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{danger_mode}{Logical, activate danger mode (focus on cancel button).}

\item{btn_labels}{Labels for buttons.}
}
\description{
Launch a popup to ask confirmation to the user
}
\examples{

\dontrun{

if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  tags$h1("Confirm sweet alert"),
  actionButton(
    inputId = "go",
    label = "Launch confirmation dialog"
  ),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {

 observeEvent(input$go, {
   confirmSweetAlert(
     session = session, inputId = "myconfirmation", type = "warning",
     title = "Want to confirm ?", danger_mode = TRUE
   )
 })

  output$res <- renderPrint(input$myconfirmation)

}

shinyApp(ui = ui, server = server)

}

}
}
\seealso{
\code{\link{sendSweetAlert}}, \code{\link{inputSweetAlert}}
}
