% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-selectpicker.R
\name{pickerInput}
\alias{pickerInput}
\title{Select picker Input Control}
\usage{
pickerInput(inputId, label = NULL, choices, selected = NULL,
  multiple = FALSE, options = list(), choicesOpt = NULL, width = NULL,
  inline = FALSE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display a text in the center of the switch.}

\item{choices}{List of values to select from. If elements of the
list are named then that name rather than the value is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if multiple = TRUE).
If not specified then defaults to the first value for single-select lists
 and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{options}{Options to customize the select picker,
see \url{https://silviomoreto.github.io/bootstrap-select/options/}.
For limit the number of selections, see example below.}

\item{choicesOpt}{Options for choices in the dropdown menu.}

\item{width}{The width of the input : 'auto', 'fit', '100px', '75\%'.}

\item{inline}{Put the label and the picker on the same line.}
}
\value{
A select control that can be added to a UI definition.
}
\description{
Create a select picker (\url{https://silviomoreto.github.io/bootstrap-select/})
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

# You can run the gallery to see other examples
shinyWidgetsGallery()


# Simple example
ui <- fluidPage(
  pickerInput(inputId = "somevalue", label = "A label", choices = c("a", "b")),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderPrint({ input$somevalue })
}
shinyApp(ui, server)


### Add actions box for selecting
# deselecting all options

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  br(),
  pickerInput(
    inputId = "p1",
    label = "Select all option",
    choices = rownames(mtcars),
    multiple = TRUE,
    options = list(`actions-box` = TRUE)
  ),
  br(),
  pickerInput(
    inputId = "p2",
    label = "Select all option / custom text",
    choices = rownames(mtcars),
    multiple = TRUE,
    options = list(
      `actions-box` = TRUE,
      `deselect-all-text` = "None...",
      `select-all-text` = "Yeah, all !",
      `none-selected-text` = "zero"
    )
  )
)

server <- function(input, output, session) {

}

shinyApp(ui = ui, server = server)



### Customize the values displayed in the box ----

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  br(),
  pickerInput(
    inputId = "p1",
    label = "Default",
    multiple = TRUE,
    choices = rownames(mtcars),
    selected = rownames(mtcars)[1:5]
  ),
  br(),
  pickerInput(
    inputId = "p1b",
    label = "Default with | separator",
    multiple = TRUE,
    choices = rownames(mtcars),
    selected = rownames(mtcars)[1:5],
    options = list(`multiple-separator` = " | ")
  ),
  br(),
  pickerInput(
    inputId = "p2",
    label = "Static",
    multiple = TRUE,
    choices = rownames(mtcars),
    selected = rownames(mtcars)[1:5],
    options = list(`selected-text-format`= "static",
                   title = "Won't change")
  ),
  br(),
  pickerInput(
    inputId = "p3",
    label = "Count",
    multiple = TRUE,
    choices = rownames(mtcars),
    selected = rownames(mtcars)[1:5],
    options = list(`selected-text-format`= "count")
  ),
  br(),
  pickerInput(
    inputId = "p3",
    label = "Customize count",
    multiple = TRUE,
    choices = rownames(mtcars),
    selected = rownames(mtcars)[1:5],
    options = list(
      `selected-text-format`= "count",
      `count-selected-text` = "{0} models choosed (on a total of {1})"
    )
  )
)

server <- function(input, output, session) {

}

shinyApp(ui = ui, server = server)



### Limit the number of selections ----

library(shiny)
library(shinyWidgets)
ui <- fluidPage(
  pickerInput(
    inputId = "groups",
    label = "Select one from each group below:",
    choices = list(
      Group1 = c("1", "2", "3", "4"),
      Group2 = c("A", "B", "C", "D")
    ),
    multiple = TRUE,
    options =  list("max-options-group" = 1)
  ),
  verbatimTextOutput(outputId = "res_grp"),
  pickerInput(
    inputId = "groups_2",
    label = "Select two from each group below:",
    choices = list(
      Group1 = c("1", "2", "3", "4"),
      Group2 = c("A", "B", "C", "D")
    ),
    multiple = TRUE,
    options =  list("max-options-group" = 2)
  ),
  verbatimTextOutput(outputId = "res_grp_2"),
  pickerInput(
    inputId = "classic",
    label = "Select max two option below:",
    choices = c("A", "B", "C", "D"),
    multiple = TRUE,
    options =  list(
      "max-options" = 2,
      "max-options-text" = "No more!"
    )
  ),
  verbatimTextOutput(outputId = "res_classic")
)
server <- function(input, output) {
  output$res_grp <- renderPrint(input$groups)
  output$res_grp_2 <- renderPrint(input$groups_2)
  output$res_classic <- renderPrint(input$classic)
}
shinyApp(ui, server)

}
}

}
