% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickerOptions.R
\name{pickerOptions}
\alias{pickerOptions}
\title{Options for \code{pickerInput}}
\usage{
pickerOptions(
  actionsBox = NULL,
  container = NULL,
  countSelectedText = NULL,
  deselectAllText = NULL,
  dropdownAlignRight = NULL,
  dropupAuto = NULL,
  header = NULL,
  hideDisabled = NULL,
  iconBase = NULL,
  liveSearch = NULL,
  liveSearchNormalize = NULL,
  liveSearchPlaceholder = NULL,
  liveSearchStyle = NULL,
  maxOptions = NULL,
  maxOptionsText = NULL,
  mobile = NULL,
  multipleSeparator = NULL,
  noneSelectedText = NULL,
  noneResultsText = NULL,
  selectAllText = NULL,
  selectedTextFormat = NULL,
  selectOnTab = NULL,
  showContent = NULL,
  showIcon = NULL,
  showSubtext = NULL,
  showTick = NULL,
  size = NULL,
  style = NULL,
  tickIcon = NULL,
  title = NULL,
  virtualScroll = NULL,
  width = NULL,
  windowPadding = NULL,
  ...
)
}
\arguments{
\item{actionsBox}{When set to true, adds two buttons to the top of the dropdown menu (Select All & Deselect All). Type: boolean; Default: false.}

\item{container}{When set to a string, appends the select to a specific element or selector, e.g., container: 'body' | '.main-body' Type: string | false; Default: false.}

\item{countSelectedText}{Sets the format for the text displayed when selectedTextFormat is \code{count} or \verb{count > #}. \code{{0}} is the selected amount. \code{{1}} is total available for selection. When set to a function, the first parameter is the number of selected options, and the second is the total number of options. The function must return a string. Type: string | function; Default: function.}

\item{deselectAllText}{The text on the button that deselects all options when actionsBox is enabled. Type: string; Default: 'Deselect All'.}

\item{dropdownAlignRight}{Align the menu to the right instead of the left. If set to 'auto', the menu will automatically align right if there isn't room for the menu's full width when aligned to the left. Type: boolean | 'auto'; Default: false.}

\item{dropupAuto}{checks to see which has more room, above or below. If the dropup has enough room to fully open normally, but there is more room above, the dropup still opens normally. Otherwise, it becomes a dropup. If dropupAuto is set to false, dropups must be called manually. Type: boolean; Default: true.}

\item{header}{adds a header to the top of the menu; includes a close button by default Type: string; Default: false.}

\item{hideDisabled}{removes disabled options and optgroups from the menu data-hide-disabled: true Type: boolean; Default: false.}

\item{iconBase}{Set the base to use a different icon font instead of Glyphicons. If changing iconBase, you might also want to change tickIcon, in case the new icon font uses a different naming scheme. Type: string; Default: 'glyphicon'.}

\item{liveSearch}{When set to true, adds a search box to the top of the selectpicker dropdown. Type: boolean; Default: false.}

\item{liveSearchNormalize}{Setting liveSearchNormalize to true allows for accent-insensitive searching. Type: boolean; Default: false.}

\item{liveSearchPlaceholder}{When set to a string, a placeholder attribute equal to the string will be added to the liveSearch input. Type: string; Default: null.}

\item{liveSearchStyle}{When set to 'contains', searching will reveal options that contain the searched text. For example, searching for pl with return both Apple, Plum, and Plantain. When set to 'startsWith', searching for pl will return only Plum and Plantain. Type: string; Default: 'contains'.}

\item{maxOptions}{When set to an integer and in a multi-select, the number of selected options cannot exceed the given value. This option can also exist as a data-attribute for an \verb{<optgroup>}, in which case it only applies to that \verb{<optgroup>}. Type: integer | false; Default: false.}

\item{maxOptionsText}{The text that is displayed when maxOptions is enabled and the maximum number of options for the given scenario have been selected. If a function is used, it must return an array. \code{array[0]} is the text used when maxOptions is applied to the entire select element. \code{array[1]} is the text used when maxOptions is used on an optgroup. If a string is used, the same text is used for both the element and the optgroup. Type: string | array | function; Default: function.}

\item{mobile}{When set to true, enables the device's native menu for select menus. Type: boolean; Default: false.}

\item{multipleSeparator}{Set the character displayed in the button that separates selected options. Type: string; Default: ', '.}

\item{noneSelectedText}{The text that is displayed when a multiple select has no selected options. Type: string; Default: 'Nothing selected'.}

\item{noneResultsText}{The text displayed when a search doesn't return any results. Type: string; Default: \code{'No results matched {0}'}.}

\item{selectAllText}{The text on the button that selects all options when actionsBox is enabled. Type: string; Default: 'Select All'.}

\item{selectedTextFormat}{Specifies how the selection is displayed with a multiple select. 'values' displays a list of the selected options (separated by multipleSeparator. 'static' simply displays the select element's title. 'count' displays the total number of selected options. 'count > x' behaves like 'values' until the number of selected options is greater than x; after that, it behaves like 'count'. Type: 'values' | 'static' | 'count' | 'count > x' (where x is an integer); Default: 'values'.}

\item{selectOnTab}{When set to true, treats the tab character like the enter or space characters within the selectpicker dropdown. Type: boolean; Default: false.}

\item{showContent}{When set to true, display custom HTML associated with selected option(s) in the button. When set to false, the option value will be displayed instead. Type: boolean; Default: true.}

\item{showIcon}{When set to true, display icon(s) associated with selected option(s) in the button. Type: boolean; Default: true.}

\item{showSubtext}{When set to true, display subtext associated with a selected option in the button. Type: boolean; Default: false.}

\item{showTick}{Show checkmark on selected option (for items without multiple attribute). Type: boolean; Default: false.}

\item{size}{When set to 'auto', the menu always opens up to show as many items as the window will allow without being cut off. When set to an integer, the menu will show the given number of items, even if the dropdown is cut off. When set to false, the menu will always show all items. Type: 'auto' | integer | false; Default: 'auto'.}

\item{style}{When set to a string, add the value to the button's style. Type: string | null; Default: null.}

\item{tickIcon}{Set which icon to use to display as the "tick" next to selected options. Type: string; Default: 'glyphicon-ok'.}

\item{title}{The default title for the selectpicker. Type: string | null; Default: null.}

\item{virtualScroll}{If enabled, the items in the dropdown will be rendered using virtualization (i.e. only the items that are within the viewport will be rendered). This drastically improves performance for selects with a large number of options. Set to an integer to only use virtualization if the select has at least that number of options. Type: boolean | integer; Default: 600.}

\item{width}{When set to auto, the width of the selectpicker is automatically adjusted to accommodate the widest option. When set to a css-width, the width of the selectpicker is forced inline to the given value. When set to false, all width information is removed. Type: 'auto' | 'fit' | css-width | false (where css-width is a CSS width with units, e.g. 100px); Default: false.}

\item{windowPadding}{This is useful in cases where the window has areas that the dropdown menu should not cover - for instance a fixed header. When set to an integer, the same padding will be added to all sides. Alternatively, an array of integers can be used in the format \verb{top, right, bottom, left}. Type: integer | array; Default: 0.}

\item{...}{Other options not listed here.}
}
\description{
Wrapper of options available here: https://developer.snapappointments.com/bootstrap-select/options/
}
\note{
Documentation is from \href{https://developer.snapappointments.com/bootstrap-select/options/}{Bootstrap-select onlin page}.
}
\examples{

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    pickerInput(
      inputId = "month",
      label = "Select a month",
      choices = month.name,
      multiple = TRUE,
      options = pickerOptions(
        actionsBox = TRUE,
        title = "Please select a month",
        header = "This is a title"
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}

}
