% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-input.R
\name{treeInput}
\alias{treeInput}
\title{Tree Input Widget}
\usage{
treeInput(
  inputId,
  label,
  choices,
  selected = NULL,
  closeDepth = 1,
  returnValue = c("text", "id", "all"),
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{A \code{list} of \code{list} in a tree structure, see \code{\link[=create_tree]{create_tree()}} for examples creating the right structure.}

\item{selected}{Inital selected values, note that you have to use node ID.}

\item{closeDepth}{Expand level, default to only first one visible.}

\item{returnValue}{Value returned server-side, default to \code{"text"} the node text,
other possibilities are \code{"id"} (if no ID provided in \verb{choices = }, one is generated) or
\code{"all"} to returned all the tree under the element selected.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{"100\%}.}
}
\value{
A \code{shiny.tag} object that can be used in a UI definition.
}
\description{
A tree input widget allowing to select values in a hierarchical structure.
}
\examples{

library(shiny)
library(shinyWidgets)

# data
cities <- data.frame(
  continent = c("America", "America", "America", "Africa",
                "Africa", "Africa", "Africa", "Africa",
                "Europe", "Europe", "Europe", "Antarctica"),
  country = c("Canada", "Canada", "USA", "Tunisia", "Tunisia",
              "Tunisia", "Algeria", "Algeria", "Italy", "Germany", "Spain", NA),
  city = c("Trois-Rivières", "Québec", "San Francisco", "Tunis",
           "Monastir", "Sousse", "Alger", "Oran", "Rome", "Berlin", "Madrid", NA),
  stringsAsFactors = FALSE
)

# app
ui <- fluidPage(
  tags$h2("treeInput() example"),
  fluidRow(
    column(
      width = 4,
      treeInput(
        inputId = "ID1",
        label = "Select cities:",
        choices = create_tree(cities),
        selected = "San Francisco",
        returnValue = "text",
        closeDepth = 0
      ),
      verbatimTextOutput("res1")
    ),
    column(
      width = 4,
      treeInput(
        inputId = "ID2",
        label = "Select cities:",
        choices = create_tree(cities),
        selected = "San Francisco",
        returnValue = "text",
        closeDepth = 1
      ),
      verbatimTextOutput("res2")
    ),
    column(
      width = 4,
      treeInput(
        inputId = "ID3",
        label = "Select cities:",
        choices = create_tree(cities),
        selected = c("San Francisco", "Monastir"),
        returnValue = "text",
        closeDepth = 2
      ),
      verbatimTextOutput("res3")
    )
  )
)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$ID1)
  output$res2 <- renderPrint(input$ID2)
  output$res3 <- renderPrint(input$ID3)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\code{\link[=updateTreeInput]{updateTreeInput()}} for updating from server.
}
