% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.R
\name{addScrollAnim}
\alias{addScrollAnim}
\title{Add animation on scroll for UI element.}
\usage{
addScrollAnim(session, id, type = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{id}{the id of the UI element for which you want animation on scroll.}

\item{type}{The type of animation to use, valid values correspond to the types in \url{https://daneden.github.io/animate.css/}}
}
\description{
Add animation on scroll for UI element.
}
\examples{
if(interactive()){
library(shiny)
library(shinyanimate)
ui <- fluidPage(
  withAnim(),
    tags$h1('Scroll below to see an animation'),
    br(), br(), br(), br(), br(), br(), br(),
    br(), br(), br(), br(), br(), br(), br(),
    br(), br(), br(), br(), br(), br(), br(),
    br(), br(), br(), br(), br(), br(), br(),
    br(), br(), br(), br(), br(), br(), br(),
    br(), br(), br(), br(), br(), br(), br(),
    tags$div(id = 'title', h1('I ANIMATE ON SCROLL'))
    )
server <- function(input, output, session){
  observe(addScrollAnim(session, 'title', 'bounce'))
 }
shinyApp(ui, server)
}
}
\seealso{
\code{\link{withAnim}}
}
