% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-modal.R
\name{modal-gif}
\alias{modal-gif}
\alias{show_modal_gif}
\alias{remove_modal_gif}
\title{Show a modal with a GIF}
\usage{
show_modal_gif(
  src,
  text = NULL,
  height = "100px",
  width = "100px",
  modal_size = "s",
  session = shiny::getDefaultReactiveDomain()
)

remove_modal_gif(session = getDefaultReactiveDomain())
}
\arguments{
\item{src}{Path to the GIF, an URL or a file in www/ folder.}

\item{text}{Additional text to appear under the spinner.}

\item{height, width}{Height and width of the spinner, default to \code{'50px'} for both, must be specified.}

\item{modal_size}{One of \code{"s"} for small (the default) , \code{"m"} for medium, or \code{"l"} for large.}

\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}
}
\description{
Make a pop-up window appear from the server
with a GIF during long computation, remove it when finished.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinybusy)

  ui <- fluidPage(

    tags$h1("Modal with spinner"),
    actionButton("sleep1", "Launch a long calculation"),
    actionButton("sleep2", "And another one")
  )

  server <- function(input, output, session) {

    observeEvent(input$sleep1, {
      show_modal_gif(
        src = "https://jeroen.github.io/images/banana.gif"
      )
      Sys.sleep(5)
      remove_modal_gif()
    })

    observeEvent(input$sleep2, {
      show_modal_gif(
        src = "https://jeroen.github.io/images/banana.gif",
        width = "300px", height = "300px",
        modal_size = "m",
        text = "Please wait..."
      )
      Sys.sleep(5)
      remove_modal_gif()
    })

  }

  shinyApp(ui, server)

}
}
