% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{block}
\alias{block}
\alias{unblock}
\title{Block / unblock an UI element}
\usage{
block(
  id,
  text = "Loading",
  type = c("standard", "hourglass", "circle", "arrows", "dots", "pulse"),
  ...,
  selector = NULL,
  session = shiny::getDefaultReactiveDomain()
)

unblock(
  id,
  selector = NULL,
  timeout = 0,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Id of the element to block, for exemple an \code{outputId}.}

\item{text}{Text displayed below the blocking indicator.}

\item{type}{Type of blocking indicator.}

\item{...}{Other configuration option, see \href{https://notiflix.github.io/documentation#DocsBlock}{online documentation}.}

\item{selector}{Custom CSS selector, if used \code{id} is ignored.}

\item{session}{Default Shiny session.}

\item{timeout}{Unblock after a delay.}
}
\value{
No value.
}
\description{
Block / unblock an UI element
}
\examples{
library(shinybusy)
library(shiny)

ui <- fluidPage(

  tags$h3("Block Output"),


  fluidRow(
    column(
      width = 6,
      plotOutput(outputId = "plot1"),
      actionButton("block_manually", "Block / unblock")
    ),
    column(
      width = 6,
      plotOutput(outputId = "plot2"),
      actionButton("block_reac", "Block when calculating in reactive()")
    )
  )

)

server <- function(input, output, session) {

  output$plot1 <- renderPlot({
    barplot(table(floor(runif(100) * 6)))
  })

  observeEvent(input$block_manually, {
    if (input$block_manually \%\% 2 == 1) {
      block(id = "plot1", type = "pulse", svgColor = "#5ea4d8")
    } else {
      unblock(id = "plot1")
    }
  })

  data_r <- reactive({
    input$block_reac
    block(
      id = "plot2",
      type = "circle",
      text = "Calculating, please wait...",
      messageColor = "#FFF",
      svgColor = "#FFF",
      backgroundColor = "#5ea4d8"
    )
    Sys.sleep(3)
    data <- data.frame(x = rnorm(50), y = rnorm(50))
    unblock(id = "plot2", timeout = 300)
    return(data)
  })

  output$plot2 <- renderPlot({
    plot(data_r())
  })

}

if (interactive())
  shinyApp(ui, server)

}
