% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{accordion}
\alias{accordion}
\title{AdminLTE2 accordion container}
\usage{
accordion(..., inputId = NULL)
}
\arguments{
\item{...}{slot for accordionItem.}

\item{inputId}{Unique accordion id.}
}
\description{
Create an accordion container
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
      accordion(
       inputId = "accordion1",
        accordionItem(
          title = "Accordion 1 Item 1",
          color = "danger",
          collapsed = TRUE,
          "This is some text!"
        ),
        accordionItem(
          title = "Accordion 1 Item 2",
          color = "warning",
          collapsed = FALSE,
          "This is some text!"
        )
      ),
      accordion(
       inputId = "accordion2",
        accordionItem(
          title = "Accordion 2 Item 1",
          color = "danger",
          collapsed = TRUE,
          "This is some text!"
        ),
        accordionItem(
          title = "Accordion 2 Item 2",
          color = "warning",
          collapsed = FALSE,
          "This is some text!"
        )
      )
    ),
    title = "Accordion"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
