% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{descriptionBlock}
\alias{descriptionBlock}
\title{AdminLTE2 description block}
\usage{
descriptionBlock(
  number = NULL,
  numberColor = NULL,
  numberIcon = NULL,
  header = NULL,
  text = NULL,
  rightBorder = TRUE,
  marginBottom = FALSE
)
}
\arguments{
\item{number}{any number.}

\item{numberColor}{number color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{numberIcon}{number icon, if any. Should be written like "fa fa-times".}

\item{header}{bold text.}

\item{text}{additional text.}

\item{rightBorder}{TRUE by default. Whether to display a right border to
separate two blocks. The last block on the right should not have a right border.}

\item{marginBottom}{FALSE by default. Set it to TRUE when the
descriptionBlock is used in a boxPad context.}
}
\description{
Create a description block, perfect for writing statistics
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      solidHeader = FALSE,
      title = "Status summary",
      background = NULL,
      width = 4,
      status = "danger",
      footer = fluidRow(
        column(
          width = 6,
          descriptionBlock(
            number = "17\%", 
            numberColor = "green", 
            numberIcon = "caret-up",
            header = "$35,210.43", 
            text = "TOTAL REVENUE", 
            rightBorder = TRUE,
            marginBottom = FALSE
          )
        ),
        column(
          width = 6,
          descriptionBlock(
            number = "18\%", 
            numberColor = "red", 
            numberIcon = "caret-down",
            header = "1200", 
            text = "GOAL COMPLETION", 
            rightBorder = FALSE,
            marginBottom = FALSE
          )
        )
      )
     )
    ),
    title = "Description Blocks"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
