% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe.R
\name{apply_filters}
\alias{apply_filters}
\title{Apply Filters to an object}
\usage{
apply_filters(
  x,
  filter_list,
  filter_combine_method = "and",
  expanded = FALSE,
  cols = NULL,
  ...
)
}
\arguments{
\item{x}{An object to filter; typically a data.frame.}

\item{filter_list}{A named list of filter values, used to filter the values
in \code{x}. If \code{filter_list} is \code{NULL}, \code{x} is returned unmodified.}

\item{filter_combine_method}{A string or function indicating how to combine
multiple filters. If a string, it can be "and" (or "&") for logical AND,
or "or" (or "|") for logical OR. If a function, it should take two logical
vectors and return a combined logical vector.}

\item{expanded}{Logical; if \code{TRUE}, returns a named list of data.frames,
each containing one column, its own, filtered according to the values of
all \emph{other} filters.}

\item{cols}{Optional character vector of column names to retain in the
output when \code{x} is a data.frame. If \code{NULL} (the default), all columns are
retained.}

\item{...}{Additional arguments passed to \code{\link[=get_filter_logical]{get_filter_logical()}}.}
}
\value{
A filtered object, or a named list of filtered objects if
\code{expanded = TRUE}.
}
\description{
Applies a list of filters to an object, returning the filtered object.
}
\examples{
library(S7)
df <- data.frame(
 category = rep(letters[1:3], each = 4),
 value = 1:12,
 date = as.Date('2024-01-01') + 0:11
)
filters <- list(
  category = c("a", "b"),
  value = c(3, 11)
)

# Apply filters with logical AND
apply_filters(df, filters, filter_combine_method = "and")

# Apply filters with logical OR
apply_filters(df, filters, filter_combine_method = "or")

# Get expanded filters
apply_filters(df, filters, expanded = TRUE)

}
