% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderInput.R
\name{orderInput}
\alias{orderInput}
\title{A shiny input control to show the order of a list of items}
\usage{
orderInput(inputId, label, items, as_source = FALSE, connect = NULL,
  item_class = c("default", "primary", "success", "info", "warning",
  "danger"), placeholder = NULL, width = "500px", ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the current
order of items.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{items}{Items to display, can be a list, an atomic vector or a factor.
For list and atomic vector, if named, the names are displayed and the order
is given in values. For factor, values are displayed and the order is
given in levels}

\item{as_source}{A boolean value to determine whether the \code{orderInput}
is set as source mode. If source mode, items in this \code{orderInput} can
only be dragged (copied) to the connected non-source \code{orderInput}(s)
defined by \code{connect} argument. If non-source mode, items in the
\code{orderInput} can be dragged (moved) within or toward other connected
non-source \code{orderInput}(s) defined by \code{connect} argument.}

\item{connect}{optional, a vector of \code{inputId}(s) of other
\code{orderInput}(s) that the current \code{orderInput} connects to. The
behavior of the conneted \code{orderInput}(s) depend on the
\code{as_source} argument.}

\item{item_class}{One of the
\href{http://getbootstrap.com/css/#buttons-options}{Bootstrap
Button Styles} to apply to each item.}

\item{placeholder}{A character string to show when there is no item left in
the \code{orderInput}.}

\item{width}{The width of the input, e.g. '400px', or '100\%'. Passed to
\code{\link[shiny]{validateCssUnit}}.}

\item{...}{Arguments passed to \code{shiny::tags$div} which is used to build
the container of the \code{orderInput}.}
}
\value{
A \code{orderInput} control that can be added to a UI definition.
}
\description{
Display a list items whose order can be changed by drag and drop within or
between \code{orderInput}(s). The current items order can be obtained from
\code{input$inputId_order}.
}
\examples{
orderInput('items1', 'Items1', items = month.abb, item_class = 'info')

## build connections between orderInputs
orderInput('items2', 'Items2 (can be moved to Items1 and Items4)', items = month.abb,
           connect = c('lst1', 'lst4'), item_class = 'primary')

## build connections in source mode
orderInput('items3', 'Items3 (can be copied to List2 and List4)', items = month.abb,
           as_source = TRUE, connect = c('lst2', 'lst4'), item_class = 'success')

## show placeholder
orderInput('items4', 'Items4 (can be moved to List2)', items = NULL, connect = 'lst2',
           placeholder = 'Drag items here...')
}

