% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{Interactions}
\alias{Interactions}
\alias{jqui_draggabled}
\alias{jqui_droppabled}
\alias{jqui_resizabled}
\alias{jqui_selectabled}
\alias{jqui_sortabled}
\alias{jqui_draggable}
\alias{jqui_droppable}
\alias{jqui_resizable}
\alias{jqui_selectable}
\alias{jqui_sortable}
\title{Mouse interactions}
\usage{
jqui_draggabled(tag, options = NULL)

jqui_droppabled(tag, options = NULL)

jqui_resizabled(tag, options = NULL)

jqui_selectabled(tag, options = NULL)

jqui_sortabled(tag, options = NULL)

jqui_draggable(ui, operation = c("enable", "disable", "destroy", "save",
  "load"), options = NULL, selector = NULL, switch = NULL)

jqui_droppable(ui, operation = c("enable", "disable", "destroy", "save",
  "load"), options = NULL, selector = NULL, switch = NULL)

jqui_resizable(ui, operation = c("enable", "disable", "destroy", "save",
  "load"), options = NULL, selector = NULL, switch = NULL)

jqui_selectable(ui, operation = c("enable", "disable", "destroy", "save",
  "load"), options = NULL, selector = NULL, switch = NULL)

jqui_sortable(ui, operation = c("enable", "disable", "destroy", "save",
  "load"), options = NULL, selector = NULL, switch = NULL)
}
\arguments{
\item{options}{A list of
\href{http://api.jqueryui.com/category/interactions/}{interaction_specific_options}.
Ignored when \code{operation} is set as \code{destroy}. This parameter also
accept a \code{shiny} option that controls the shiny input value returned from
the element. See Details.}

\item{ui}{The target ui element(s) to be manipulated. Can be
\itemize{
\item A \code{shiny.tag} or \code{shiny.tag.list} object
\item A string of \href{https://api.jquery.com/category/selectors/}{jQuery_selector}
\item A \link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{http://api.jquery.com/Types/#jQuery}{jQuery object}.
}}

\item{operation}{A string to determine how to manipulate the mouse interaction.
Should be one of \code{enable}, \code{disable}, \code{destroy}, \code{save} and \code{load}. Ignored
when \code{ui} is a \code{shiny.tag} or \code{shiny.tag.list} object. See Details.}

\item{selector, tag, switch}{Deprecated, just keep for backward compatibility.
Please use \code{ui} and \code{operation} parameters instead.}
}
\value{
The same object passed in the \code{ui} parameter
}
\description{
Attach mouse-based interactions to shiny html tags and input/output widgets,
and provide ways to manipulate them. The interactions include:
\itemize{
\item \href{http://api.jqueryui.com/draggable/}{draggable}: Allow elements to be
moved using the mouse.
\item \href{http://api.jqueryui.com/droppable/}{droppable}: Create targets for
draggable elements.
\item \href{http://api.jqueryui.com/resizable/}{resizable}: Change the size of an
element using the mouse.
\item \href{http://api.jqueryui.com/selectable/}{selectable}: Use the mouse to select
elements, individually or in a group.
\item \href{http://api.jqueryui.com/sortable/}{sortable}: Reorder elements in a list
or grid using the mouse.
}
}
\details{
The first parameter \code{ui} determines the target shiny ui element(s) to work
with. It accepts objects with different classes. When you provide a
\code{shiny.tag} (e.g., shiny inputs/outputs or ui created by \link[shiny:tags]{shiny::tags}) or a
\code{shiny.tag.list} (by \link[shiny:tagList]{tagList()}) object, the functions return the same
ui object with interaction effects attached. When a
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} or a javascript
expression is provided, the functions first use it to locate the target ui
element(s) in shiny app, and then attach or manipulate the interactions.
Therefore, you can use the first way in \code{ui} of a shiny app to created
elements with interaction effects, or use the second way in \code{server} to
manipulate the interactions.

The \code{operation} parameter is valid only in the second way. It determines how
to manipulate the interaction, which includes:
\itemize{
\item \code{enable}: Attach the corresponding mouse interaction to the target(s).
\item \code{disable}: Attach the interaction if not and disable it at once (only set the options).
\item \code{destory}: Destroy the interaction.
\item \code{save}: Attach the interaction if not and save the current interaction state.
\item \code{load}: If interaction attached, restore the target(s) to the last saved interaction state.
}

With mouse interactions attached, the corresponding interaction states, e.g.
\code{position} of draggable, \code{size} of resizable, \code{selected} of selectable and
\code{order} of sortable, will be send to server in the form of
\code{input$<id>_<state>}. The default values can be overridden by setting the
\code{shiny} option in the \code{options} parameter. Please see the vignette
\code{Introduction to shinyjqui} for more details.

The functions \code{jqui_draggabled()}, \code{jqui_droppabled()}, \code{jqui_resizabled()},
\code{jqui_selectabled()} and \code{jqui_sortabled()} are deprecated. Please use the
corresponding \code{-able()} functions instead.
}
\examples{
library(shiny)
library(highcharter)

## used in ui
jqui_resizable(actionButton('btn', 'Button'))
jqui_draggable(plotOutput('plot', width = '400px', height = '400px'),
                options = list(axis = 'x'))
jqui_selectable(
  div(
    id = 'sel_plots',
    highchartOutput('highchart', width = '300px'),
    plotOutput('ggplot', width = '300px')
  ),
  options = list(
    classes = list(`ui-selected` = 'ui-state-highlight')
  )
)
jqui_sortable(tags$ul(
  id = 'lst',
  tags$li('A'),
  tags$li('B'),
  tags$li('C')
))

## used in server
\dontrun{
  jqui_draggable('#foo', options = list(grid = c(80, 80)))
  jqui_droppable('.foo', operation = "enable")
}

## use shiny input
if (interactive()) {
  shinyApp(
    server = function(input, output) {
      output$foo <- renderHighchart({
        hchart(mtcars, "scatter", hcaes(x = cyl, y = mpg))
      })
      output$position <- renderPrint({
        print(input$foo_position)
      })
    },
    ui = fluidPage(
      verbatimTextOutput('position'),
      jqui_draggable(highchartOutput('foo', width = '200px', height = '200px'))
    )
  )
}

## custom shiny input
func <- JS('function(event, ui){return $(event.target).offset();}')
options <-  list(
  shiny = list(
    abs_position = list(
      dragcreate = func, # send returned value back to shiny when interaction is created.
      drag = func # send returned value to shiny when dragging.
    )
  )
)
jqui_draggable(highchartOutput('foo', width = '200px', height = '200px'),
                options = options)


}
