% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourInput.R
\name{colourInput}
\alias{colourInput}
\title{Create a colour input control}
\usage{
colourInput(inputId, label, value = "white", showColour = c("both", "text",
  "background"), palette = c("square", "limited"), allowedCols,
  allowTransparent = FALSE, transparentText, returnName = FALSE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or `\code{NULL} for no label.}

\item{value}{Initial value (can be a colour name or HEX code)}

\item{showColour}{Whether to show the chosen colour as text inside the input,
as the background colour of the input, or both (default).}

\item{palette}{The type of colour palette to allow the user to select colours
from. \code{square} (default) shows a square colour palette that allows the
user to choose any colour, while \code{limited} only gives the user a
predefined list of colours to choose from.}

\item{allowedCols}{A list of colours that the user can choose from. Only
applicable when \code{palette == "limited"}. The \code{limited} palette
uses a default list of 40 colours if \code{allowedCols} is not defined.}

\item{allowTransparent}{If \code{TRUE}, then add a checkbox that allows the
user to select the \code{transparent} colour.}

\item{transparentText}{The text to show beside the transparency checkbox
when \code{allowTransparent} is \code{TRUE}. The default value is
"Transparent", but you can change it to "None" or any other string. This has
no effect on the return value from the input; when the checkbox is checked,
the input will always return the string "transparent".}

\item{returnName}{If \code{TRUE}, then return the name of an R colour instead
of a HEX value when possible.}
}
\description{
Create an input control to select a colour.
}
\details{
A colour input allows users to select a colour by clicking on the desired
colour, or by entering a valid HEX colour in the input box. The input can
be initialized with either a colour name or a HEX value. The return value is
a HEX value by default, but you can use the \code{returnName = TRUE} parameter
to get an R colour name instead (only when an R colour exists for the
selected colour).

Since most functions in R that accept colours can also accept the value
"transparent", \code{colourInput} has an option to allow selecting the
"transparent" colour. When the user checks the checkbox for this special
colour, the returned value form the input is "transparent".
}
\note{
Unlike the rest of the \code{shinyjs} functions, this function does
not require you to call \code{useShinyjs()} first.

See \href{http://daattali.com/shiny/colourInput/}{http://daattali.com/shiny/colourInput/}
for a live demo.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      strong("Selected colour:", textOutput("value", inline = TRUE)),
      colourInput("col", "Choose colour", "red"),
      h3("Update colour input"),
      textInput("text", "New colour: (colour name or HEX value)"),
      selectInput("showColour", "Show colour",
        c("both", "text", "background")),
      selectInput("palette", "Colour palette",
        c("square", "limited")),
      checkboxInput("allowTransparent", "Allow transparent", FALSE),
      checkboxInput("returnName", "Return R colour name", FALSE),
      actionButton("btn", "Update")
    ),
    server = function(input, output, session) {
      observeEvent(input$btn, {
        updateColourInput(session, "col",
          value = input$text, showColour = input$showColour,
          allowTransparent = input$allowTransparent,
          palette = input$palette,
          returnName = input$returnName)
      })
      output$value <- renderText(input$col)
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{updateColourInput}}
\code{\link[shinyjs]{colourPicker}}
}

