% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarto_ext.R
\name{quarto_ext}
\alias{quarto_ext}
\title{Quarto extension for shinylive}
\usage{
quarto_ext(
  args = commandArgs(trailingOnly = TRUE),
  ...,
  pretty = is_interactive()
)
}
\arguments{
\item{args}{Command line arguments passed by the extension. See details for more information.}

\item{...}{Ignored.}

\item{pretty}{Whether to pretty print the JSON output.}
}
\value{
Nothing. Values are printed to stdout.
}
\description{
Integration with https://github.com/quarto-ext/shinylive
}
\section{Command arguments}{


The first argument must be \code{"extension"}. This is done to match
\code{py-shinylive} so that it can nest other sub-commands under the \code{extension}
argument to minimize the api clutter the user can see.
\subsection{CLI Interface}{
\itemize{
\item \verb{extension info}
\itemize{
\item Prints information about the extension including:
\itemize{
\item \code{version}: The version of the R package
\item \code{assets_version}: The version of the web assets
\item \code{scripts}: A list of paths scripts that are used by the extension,
mainly \code{codeblock-to-json}
}
\item Example

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "version": "0.1.0",
  "assets_version": "0.2.0",
  "scripts": \{
    "codeblock-to-json": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/scripts/codeblock-to-json.js"
  \}
\}
}\if{html}{\out{</div>}}
}
\item \verb{extension base-htmldeps}
\itemize{
\item Prints the language agnostic quarto html dependencies as a JSON array.
\itemize{
\item The first html dependency is the \code{shinylive} service workers.
\item The second html dependency is the \code{shinylive} base dependencies. This
dependency will contain the core \code{shinylive} asset scripts (JS files
automatically sourced), stylesheets (CSS files that are automatically
included), and resources (additional files that the JS and CSS files can
source).
}
\item Example

\if{html}{\out{<div class="sourceCode">}}\preformatted{[
  \{
    "name": "shinylive-serviceworker",
    "version": "0.2.0",
    "meta": \{ "shinylive:serviceworker_dir": "." \},
    "serviceworkers": [
      \{
        "source": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive-sw.js",
        "destination": "/shinylive-sw.js"
      \}
    ]
  \},
  \{
    "name": "shinylive",
    "version": "0.2.0",
    "scripts": [\{
      "name": "shinylive/load-shinylive-sw.js",
      "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/load-shinylive-sw.js",
        "attribs": \{ "type": "module" \}
    \}],
    "stylesheets": [\{
      "name": "shinylive/shinylive.css",
      "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/shinylive.css"
    \}],
    "resources": [
      \{
        "name": "shinylive/shinylive.js",
        "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/shinylive.js"
      \},
      ... # [ truncated ]
    ]
  \}
]
}\if{html}{\out{</div>}}
}
\item \verb{extension language-resources}
\itemize{
\item Prints the language-specific resource files as JSON that should be added to the quarto html dependency.
\itemize{
\item For r-shinylive, this includes the webr resource files
\item For py-shinylive, this includes the pyodide and pyright resource files.
}
\item Example

\if{html}{\out{<div class="sourceCode">}}\preformatted{[
  \{
    "name": "shinylive/webr/esbuild.d.ts",
    "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/webr/esbuild.d.ts"
  \},
  \{
    "name": "shinylive/webr/libRblas.so",
    "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/webr/libRblas.so"
  \},
  ... # [ truncated ]
]
}\if{html}{\out{</div>}}
}
\item \verb{extension app-resources}
\itemize{
\item Prints app-specific resource files as JSON that should be added to the \code{"shinylive"} quarto html dependency.
\item Currently, r-shinylive does not return any resource files.
\item Example

\if{html}{\out{<div class="sourceCode">}}\preformatted{[
  \{
    "name": "shinylive/pyodide/anyio-3.7.0-py3-none-any.whl",
    "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/pyodide/anyio-3.7.0-py3-none-any.whl"
  \},
  \{
    "name": "shinylive/pyodide/appdirs-1.4.4-py2.py3-none-any.whl",
    "path": "/<ASSETS_CACHE_DIR>/shinylive-0.2.0/shinylive/pyodide/appdirs-1.4.4-py2.py3-none-any.whl"
  \},
  ... # [ truncated ]
]
}\if{html}{\out{</div>}}
}
}
}
}

