% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-pwd.R
\name{module-password}
\alias{module-password}
\alias{pwd_ui}
\alias{pwd_server}
\title{New password module}
\usage{
pwd_ui(id, tag_img = NULL, status = "primary")

pwd_server(
  input,
  output,
  session,
  user,
  update_pwd,
  validate_pwd = NULL,
  use_token = FALSE
)
}
\arguments{
\item{id}{Module's id.}

\item{tag_img}{A \code{tags$img} to be displayed on the authentication module.}

\item{status}{Bootstrap status to use for the panel and the button.
Valid status are: \code{"default"}, \code{"primary"}, \code{"success"},
\code{"warning"}, \code{"danger"}.}

\item{input, output, session}{Standard Shiny server arguments.}

\item{user}{A \code{reactiveValues} with a slot \code{user},
referring to the user for whom the password is to be changed.}

\item{update_pwd}{A \code{function} to perform an action when changing password is successful.
Two arguments will be passed to the function: \code{user} (username) and \code{password}
(the new password). Must return a list with at least a slot \code{result} with \code{TRUE}
or \code{FALSE}, according if the update has been successful.}

\item{validate_pwd}{A \code{function} to validate the password enter by the user.
Default is to check for the password to have at least one number, one lowercase,
one uppercase and be of length 6 at least.}

\item{use_token}{Add a token in the URL to check authentication. Should not be used directly.}
}
\description{
New password module
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinymanager)

  ui <- fluidPage(
    tags$h2("Change password module"),
    actionButton(
      inputId = "ask", label = "Ask to change password"
    ),
    verbatimTextOutput(outputId = "res_pwd")
  )

  server <- function(input, output, session) {

    observeEvent(input$ask, {
      insertUI(
        selector = "body",
        ui = tags$div(
          id = "module-pwd",
          pwd_ui(id = "pwd")
        )
      )
    })

    output$res_pwd <- renderPrint({
      reactiveValuesToList(pwd_out)
    })

    pwd_out <- callModule(
      module = pwd_server,
      id = "pwd",
      user = reactiveValues(user = "me"),
      update_pwd = function(user, pwd) {
        # store the password somewhere
        list(result = TRUE)
      }
    )

    observeEvent(pwd_out$relog, {
      removeUI(selector = "#module-pwd")
    })
  }

  shinyApp(ui, server)

}
}
