% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-file-input.R
\name{material_file_input}
\alias{material_file_input}
\title{Create a shinymaterial file input}
\usage{
material_file_input(input_id, label = "File", color = NULL)
}
\arguments{
\item{input_id}{String. The input identifier used to access the value.}

\item{label}{String. The file input button text.}

\item{color}{String. The color of the file input. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors.  \emph{This input requires using color hex codes, rather than the word form. E.g., "#ef5350", rather than "red lighten-1".}}
}
\description{
Build a shinymaterial file input.
}
\examples{
if (interactive()) {
  
  ui <- 
  material_page(
    material_row(
      material_column(
        width = 12,
        material_file_input(
          input_id = "file_1", 
          label = "file"
        )
      )
    ),
    material_row(
      material_column(
        width = 12,
        tableOutput("contents")
      )
    )
  )
  
  server <- function(input, output) {
    output$contents <- renderTable({
      # input$file_1 will be NULL initially. After the user selects
      # and uploads a file, it will be a data frame with 'name',
      # 'size', 'type', and 'datapath' columns. The 'datapath'
      # column will contain the local filenames where the data can
      # be found.
      in_file <- input$file_1
      
      if (is.null(in_file))
        return(NULL)
      
      read.csv(in_file$datapath)
    })
  }
  
  shinyApp(ui, server)
  
}
}
