% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenshot.R
\name{screenshotButton}
\alias{screenshotButton}
\title{Button that captures a screenshot of a shiny app}
\usage{
screenshotButton(
  selector = "body",
  filename = "shinyscreenshot",
  id = "",
  scale = 1,
  timer = 0,
  ...
)
}
\arguments{
\item{selector}{CSS selector for the element that should be captured. If multiple
elements match the selector, only the first one is captured. Default is to capture
the entire page.}

\item{filename}{Name of the file to be saved. A PNG extension will automatically be added.}

\item{id}{As an alternative to \code{selector}, an ID of the element that should be captured
can be provided. If \code{id} is provided, then \code{selector} is ignored. When used in a module,
the \code{id} \strong{does} need to be namespaced, like any other UI element.}

\item{scale}{The scale of the image. Default is 1, which means the dimensions of the image
will be exactly the dimensions in the browser. For example, a value of 2 will result in an
image that's twice the height and width (and a larger file size).}

\item{timer}{Number of seconds to wait before taking the screenshot. Default is 0, which
takes a screenshot immediately.}

\item{...}{Any other parameters that should be passed along to the \code{\link[shiny:actionButton]{shiny::actionButton()}}.}
}
\description{
Create a button that, when clicked, captures a screenshot of the Shiny app.
Screenshots can be either of the entire viewable page (default), or of a specific
section of the page. The captured image is automatically downloaded as a
PNG image.\cr\cr
This function gets called from the UI portion of a Shiny app, unlike
\code{\link[=screenshot]{screenshot()}} which is similar but gets called from the server.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyscreenshot)

  shinyApp(
    ui = fluidPage(
      h1("{shinyscreenshot} demo"),
      screenshotButton(label = "Capture entire page"),
      screenshotButton(label = "Capture plot", id = "plot"), br(), br(),
      numericInput("num", "Number of points", 50),
      plotOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        plot(runif(input$num))
      })
    }
  )
}
}
