% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_shinysurveys.R
\name{listInputExtensions}
\alias{listInputExtensions}
\title{List all registered survey extensions}
\usage{
listInputExtensions()
}
\value{
A named list containing the registered input type and their associated functions.
}
\description{
List all registered survey extensions
}
\examples{

if (interactive()) {

  # Register a date input to {shinysurveys},
  # limiting possible dates to a twenty-day period.

  extendInputType("slider", {
    shiny::sliderInput(
      inputId = surveyID(),
      label = surveyLabel(),
      min = 1,
      max = 10,
      value = 5
      )
    })

  # Register a slider input to {shinysurveys}
  # with a custom minimum and maximum value.

  extendInputType("date", {
    shiny::dateInput(
      inputId = surveyID(),
      value = Sys.Date(),
      label = surveyLabel(),
      min = Sys.Date()-10,
      max = Sys.Date()+10
    )
  })

  listInputExtensions()

}

}
