% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinytoastr.R
\name{toastr_success}
\alias{toastr_error}
\alias{toastr_info}
\alias{toastr_success}
\alias{toastr_warning}
\title{Create toastr notifications}
\usage{
toastr_success(message, title = "", closeButton = FALSE,
  newestOnTop = FALSE, progressBar = FALSE, position = c("top-right",
  "top-center", "top-left", "top-full-width", "bottom-right", "bottom-center",
  "bottom-left", "bottom-full-width"), preventDuplicates = FALSE,
  showDuration = 300, hideDuration = 1000, timeOut = 5000,
  extendedTimeOut = 1000, showEasing = c("swing", "linear"),
  hideEasing = c("swing", "linear"), showMethod = c("fadeIn", "slideDown",
  "show"), hideMethod = c("fadeOut", "hide"))

toastr_info(message, title = "", closeButton = FALSE, newestOnTop = FALSE,
  progressBar = FALSE, position = c("top-right", "top-center", "top-left",
  "top-full-width", "bottom-right", "bottom-center", "bottom-left",
  "bottom-full-width"), preventDuplicates = FALSE, showDuration = 300,
  hideDuration = 1000, timeOut = 5000, extendedTimeOut = 1000,
  showEasing = c("swing", "linear"), hideEasing = c("swing", "linear"),
  showMethod = c("fadeIn", "slideDown", "show"), hideMethod = c("fadeOut",
  "hide"))

toastr_warning(message, title = "", closeButton = FALSE,
  newestOnTop = FALSE, progressBar = FALSE, position = c("top-right",
  "top-center", "top-left", "top-full-width", "bottom-right", "bottom-center",
  "bottom-left", "bottom-full-width"), preventDuplicates = FALSE,
  showDuration = 300, hideDuration = 1000, timeOut = 5000,
  extendedTimeOut = 1000, showEasing = c("swing", "linear"),
  hideEasing = c("swing", "linear"), showMethod = c("fadeIn", "slideDown",
  "show"), hideMethod = c("fadeOut", "hide"))

toastr_error(message, title = "", closeButton = FALSE,
  newestOnTop = FALSE, progressBar = FALSE, position = c("top-right",
  "top-center", "top-left", "top-full-width", "bottom-right", "bottom-center",
  "bottom-left", "bottom-full-width"), preventDuplicates = FALSE,
  showDuration = 300, hideDuration = 1000, timeOut = 5000,
  extendedTimeOut = 1000, showEasing = c("swing", "linear"),
  hideEasing = c("swing", "linear"), showMethod = c("fadeIn", "slideDown",
  "show"), hideMethod = c("fadeOut", "hide"))
}
\arguments{
\item{message}{Message to show.}

\item{title}{Optional title, shown on the top.}

\item{closeButton}{Whether to show a close button. Even if there
is a close button, the notification can still be closed by clicking
on it. For sticky notifications, it is good practice to show the close
button, to tell the user that the notification can be closed.}

\item{newestOnTop}{Whether to have the newest notification on the top.}

\item{progressBar}{Whether to show a progress bar.}

\item{position}{Where to put the notification. Possible values:
\code{top-right}, \code{top-center}, \code{top-left},
\code{top-full-width}, and the corresponding \code{bottom-right}, etc.}

\item{preventDuplicates}{Whether to prevent showing exactly the
same message as the previous one. Note that only the message matters
here, the title is ignored.}

\item{showDuration}{How long the initial show transition should take,
in milliseconds.}

\item{hideDuration}{How long the final hide transition should take,
in milliseconds.}

\item{timeOut}{How long the notification should be kept on the screen,
in milliseconds. Set it to zero to keep it on the screen until it is
clicked. Note that if the mouse cursor is over the notification, then
it is kept on the screen for \code{extendedTimeOut} milliseconds,
after the cursor has left.}

\item{extendedTimeOut}{How long to keep the notification on the screen
after the mouse cursor leaves it, in milliseconds.}

\item{showEasing}{Animation easing to show the notification.
Possible values: \code{swing}, \code{linear}.}

\item{hideEasing}{Animation easing to hide the notification.
Possible values: \code{swing}, \code{linear}.}

\item{showMethod}{Animation to show the notification.
Possible values: \code{fadeIn}, \code{slideDown}, \code{show}.}

\item{hideMethod}{Animation to hide the notification.
Possible values: \code{fadeOut}, \code{hide}.}
}
\description{
There are four functions to create notifications:
\code{toastr_success}, \code{toastr_info}, \code{toastr_warning} and
\code{toastr_error}. They have exactly the same arguments and API
in general, but they create different kinds of notifications, styled
appropriately.
}
\details{
By default, the notifications disappear automatically after a timeout,
unless the mouse cursor is over them.
}
\section{Example}{


You typically use these functions in the definition of the Shiny
server program, as a response to an event, i.e. in the output functions,
reactives, or in \code{observe} or \code{observeEvent}. Here is
an example that shows a note when the data was successfully written to
a database, and an error otherwise. \preformatted{  observeEvent(
    input$save_button,
    {
      tryCatch(
        {
          writeToDB(data)
          toastr_success("Saved to database")
        },
        error = function(e) {
          toastr_error(title = "Database error", conditionMessage(e))
        }
      }
    }
  )
}
\examples{
## See above
}
\seealso{
\code{\link{useToastr}}
}

