% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/showtext.R
\name{showtext.opts}
\alias{showtext.opts}
\title{Setting Options for 'showtext' package}
\usage{
showtext.opts(...)
}
\arguments{
\item{\dots}{Options to be set, expressed in \code{name = value} pairs.
             It can also be a list containing these pairs (for example,
             the list returned by a previous call of \code{showtext.opts()}).
             Currently accepted parameters are \code{nseg} and \code{dpi}.
             See the \strong{Options Used} section.}
}
\description{
This function sets parameters that will affect the apprearance of the
graphs created with \pkg{showtext}.
}
\section{Options Used}{

\describe{
    \item{\code{nseg}}{Parameter to control the smoothness of the outlines
                       of glyphs, typically used in vector graphics devices
                       such as \code{pdf()} and \code{svg()}.
                       It is the number of line segments to approximate
                       a piece of curve in the glyph. The larger \code{nseg} is,
                       the smoother text outlines would be, but also with
                       larger file size for vector graphics. Usually a value
                       between 5~20 would be enough.}
    \item{\code{dpi}}{An integer that gives the resolution
                      of the device. This parameter is only used in bitmap
                      and on-screen graphics devices such as \code{png()} and
                      \code{x11()}, to determine the pixel size of text from
                      point size. For example, if \code{dpi} is set to 96,
                      then a character with 12 point size will have a pixel
                      size of \code{12 * 96 / 72 = 16}.}
}
}
\examples{
\dontrun{
## Set dpi to 200
op = showtext.opts(dpi = 200)

png("dpi_200.png", 800, 800, res = 200)
par(family = "sans")
showtext.begin()

set.seed(123)
plot(density(rnorm(100)))

showtext.end()
dev.off()

## Restore old options
showtext.opts(op)

png("dpi_96.png", 800, 800, res = 96)
par(family = "sans")
showtext.begin()

set.seed(123)
plot(density(rnorm(100)))

showtext.end()
dev.off()
}
}
\author{
Yixuan Qiu <\url{http://statr.me/}>
}

