% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_shrink_TVP_res.R
\name{plot.shrinkTVP}
\alias{plot.shrinkTVP}
\title{Graphical summary of posterior distribution}
\usage{
\method{plot}{shrinkTVP}(x, pars = c("beta"), nplot = 3, mar = c(2,
  4, 1, 2) + 0.1, ...)
}
\arguments{
\item{x}{a \code{shrinkTVP} object.}

\item{pars}{a character vector containing the names of the parameters to be visualized.
The names have to coincide with the names of the list elements of the \code{shrinkTVP}
object. Throws an error if any element of \code{pars} does not fulfill this criterium.
The default is \code{c("beta")}.}

\item{nplot}{positive integer that indicates the number of tvp plots to display on a single
page before a new page is generated. The default value is 3.}

\item{mar}{A numerical vector of the form \code{c(bottom, left, top, right)} which gives the number of lines of margin to be
specified on the four sides of the plot, as in \code{\link{par}}. The default is c(2, 4, 1, 2) + 0.1.}

\item{...}{further arguments to be passed to the respective plotting functions.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{plot.shrinkTVP} generates plots visualizing the posterior distribution.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

output <- shrinkTVP(y ~ x1 + x2, data)
plot(output)
}

## Will produce an error because 'hello' is not a parameter in the model
\dontrun{
plot(output, pars = c("beta", "hello"))
}

}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
