% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{preCategorize}
\alias{preCategorize}
\title{Checks for signal in the data.}
\usage{
preCategorize(normalizedInput, threshold_intensity_range = 0.1,
  threshold_minimum_for_intensity_maximum = 0.3)
}
\arguments{
\item{normalizedInput}{is the output of the sicegar::normalizeData() function.}

\item{threshold_intensity_range}{minimum for intensity range, i.e. it is the lower limit for the allowed difference between the maximum and minimum of the intensities (Default is 0.1, and the values are based on actual, not the rescaled data.).}

\item{threshold_minimum_for_intensity_maximum}{minimum allowed value for intensity maximum. (Default is 0.3, and the values are based on actual, not the rescaled data.).}
}
\value{
Function returns a brief decision list that includes information about the decision process. Post important part of this information is decisionList$decisionwhich might be either "no_signal" or "not_no_signal".
}
\description{
Checks if the signal is present in the data. Often a high percentage of high through-put data does not contain a signal. Checking if data does not contain signal before doing a sigmoidal or double sigmoidal fit can make the analysis of data from high-throughput experiments much faster.
}
\examples{
# Example 1 with double sigmoidal data

time=seq(3, 24, 0.1)

#simulate intensity data and add noise
noise_parameter = 0.2
intensity_noise = runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity = sicegar::doublesigmoidalFitFormula(time,
                                              finalAsymptoteIntensityRatio = .3,
                                              maximum = 4,
                                              slope1Param = 1,
                                              midPoint1Param = 7,
                                              slope2Param = 1,
                                              midPointDistanceParam = 8)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- sicegar::normalizeData(dataInput, dataInputName = "sample001")
isThis_nosignal <- sicegar::preCategorize(normalizedInput = normalizedInput)



# Example 2 with no_signal data

time <- seq(3, 24, 0.1)

#simulate intensity data and add noise
noise_parameter <- 0.05
intensity_noise <- runif(n = length(time), min = 0, max = 1) * noise_parameter * 2e-04
intensity <- sicegar::doublesigmoidalFitFormula(time,
                                               finalAsymptoteIntensityRatio = .3,
                                               maximum = 2e-04,
                                               slope1Param = 1,
                                               midPoint1Param = 7,
                                               slope2Param = 1,
                                               midPointDistanceParam = 8)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity=intensity, time=time)
normalizedInput <- sicegar::normalizeData(dataInput,dataInputName = "sample001")
isThis_nosignal <- sicegar::preCategorize(normalizedInput = normalizedInput)

}
