% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force.R
\name{force}
\alias{force}
\alias{sg_force}
\alias{sg_force_start}
\alias{sg_force_stop}
\alias{sg_force_restart_p}
\alias{sg_force_restart}
\alias{sg_force_start_p}
\alias{sg_force_stop_p}
\alias{sg_force_kill_p}
\alias{sg_force_config_p}
\title{Add forceAtlas2}
\usage{
sg_force(sg, ...)

sg_force_start(sg, ...)

sg_force_stop(sg, delay = 5000)

sg_force_restart_p(proxy, ..., refresh = TRUE)

sg_force_restart(sg, data, delay, cumsum = TRUE)

sg_force_start_p(proxy, ..., refresh = TRUE)

sg_force_stop_p(proxy)

sg_force_kill_p(proxy)

sg_force_config_p(proxy, ...)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{...}{Any parameter, see \href{https://github.com/jacomyal/sigma.js/tree/master/plugins/sigma.layout.forceAtlas2}{official documentation}.}

\item{delay}{Milliseconds after which the layout algorithm should stop running.}

\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{refresh}{Whether to refresh the graph after node is dropped, required to take effect.}

\item{data}{\code{data.frame} holding \code{delay} column.}

\item{cumsum}{Whether to compute the cumulative sum of the delay.}
}
\description{
Implementation of \href{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0098679}{forceAtlas2}.
}
\details{
The delay helps for build dynamic visualisations where nodes and edges do not appear all at the same time.
How the delay works depends on the \code{cumsum} parameter. if \code{TRUE} the function computes the cumulative sum
of the delay to effectively add each row one after the other: delay is thus applied at each row (number of seconds to wait
before the row is added *since the previous row*). If \code{FALSE} this is the number of milliseconds to wait before the node or
edge is added to the visualisation; \code{delay} is used as passed to the function.
}
\section{Functions}{

\itemize{
\item{\code{sg_force}, \code{sg_force_start} starts the forceAtlas2 layout}
\item{\code{sg_force_stop} stops the forceAtlas2 layout after a \code{delay} milliseconds}
\item{\code{sg_force_restart_p} proxy to re-starts (\code{kill} then \code{start}) the forceAtlas2 layout, the options you pass to this function are applied on restart. If forceAtlas2 has not started yet it is launched.}
\item{\code{sg_force_start_p} proxy to start forceAtlas2.}
\item{\code{sg_force_stop_p} proxy to stop forceAtlas2.}
\item{\code{sg_force_kill_p} proxy to ompletely stops the layout and terminates the assiociated worker. You can still restart it later, but a new worker will have to initialize.}
\item{\code{sg_force_config_p} proxy to set configurations of forceAtlas2.}
\item{\code{sg_force_restart} Restarts (kills then starts) forceAtlas2 at given delay.}
}
}

\examples{
nodes <- sg_make_nodes(50)
edges <- sg_make_edges(nodes, 100)

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size) \%>\%
  sg_edges(edges, id, source, target) \%>\% 
  sg_force() \%>\% 
  sg_force_stop() # stop force after 5 seconds

}
\seealso{
\href{https://github.com/jacomyal/sigma.js/tree/master/plugins/sigma.layout.noverlap}{official documentation}
}
