% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tidy_parameter.R
\name{get_tidy_parameter}
\alias{get_tidy_parameter}
\title{Get Tidy Parameter from Flexmix Model}
\usage{
get_tidy_parameter(x)
}
\arguments{
\item{x}{a \code{flexmix} object or a \code{list} of \code{flexmix} objects.}
}
\value{
a \code{tibble}.
}
\description{
When users derive copy number features, it is useful to know the parameters
of the fit components, including mean, sd and coefficient of variation.
This function is used by \link{sig_tally} function and
exported to users for extra usage.
}
\examples{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
# Get all parameters
d1 <- get_tidy_parameter(cn_tally_M$components)
d1
# Get parameters for segsize feature
d2 <- get_tidy_parameter(cn_tally_M$components$segsize)
d2
}
