% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cor.R
\name{show_cor}
\alias{show_cor}
\title{A Simple and General Way for Association Analysis}
\usage{
show_cor(
  data,
  x_vars = colnames(data),
  y_vars = x_vars,
  cor_method = "spearman",
  vis_method = "square",
  lab = TRUE,
  test = TRUE,
  hc_order = FALSE,
  p_adj = NULL,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame}.}

\item{x_vars}{variables/column names shown in x axis.}

\item{y_vars}{variables/column names shown in y axis.}

\item{cor_method}{method for correlation, default is 'spearman'.}

\item{vis_method}{visualization method, default is 'square',
can also be 'circle'.}

\item{lab}{logical value. If TRUE, add correlation coefficient on the plot.}

\item{test}{if \code{TRUE}, run test for correlation and mark significance.}

\item{hc_order}{logical value. If \code{TRUE},
correlation matrix will be hc.ordered using \code{hclust} function.}

\item{p_adj}{p adjust method, see \link[stats:p.adjust]{stats::p.adjust} for details.}

\item{...}{other parameters passing to \code{ggcorrplot::ggcorrplot()}.}
}
\value{
a \code{ggplot} object
}
\description{
All variables must be continuous.
The matrix will be returned as an element of \code{ggplot} object.
This is basically a wrapper of R package
\href{https://github.com/kassambara/ggcorrplot}{ggcorrplot}.
}
\examples{
data("mtcars")
p1 <- show_cor(mtcars)
p2 <- show_cor(mtcars,
               x_vars = colnames(mtcars)[1:4],
               y_vars = colnames(mtcars)[5:8])
p3 <- show_cor(mtcars, vis_method = "circle", p_adj = "fdr")
p1
p1$cor
p2
p3

## Auto detect problem variables
mtcars$xx <- 0L
p4 <- show_cor(mtcars)
p4
}
\seealso{
\link{show_sig_feature_corrplot} for specific and more powerful
association analysis and visualization.
}
